/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceTableConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.StringSplitMode;

public class JdbcSourceConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    private JdbcConnectionConfig jdbcConnectionConfig;
    private List<JdbcSourceTableConfig> tableConfigList;
    private String whereConditionClause;
    public String compatibleMode;
    private int fetchSize;
    private boolean useDynamicSplitter;
    private int splitSize;
    private double splitEvenDistributionFactorUpperBound;
    private double splitEvenDistributionFactorLowerBound;
    private int splitSampleShardingThreshold;
    private int splitInverseSamplingRate;
    private boolean decimalTypeNarrowing;
    private boolean handleBlobAsString;
    private StringSplitMode stringSplitMode;
    private String stringSplitModeCollate;

    public static JdbcSourceConfig of(ReadonlyConfig config) {
        Builder builder = JdbcSourceConfig.builder();
        builder.jdbcConnectionConfig(JdbcConnectionConfig.of(config));
        builder.tableConfigList(JdbcSourceTableConfig.of(config));
        builder.fetchSize((Integer)config.get(JdbcSourceOptions.FETCH_SIZE));
        config.getOptional(JdbcSourceOptions.COMPATIBLE_MODE).ifPresent(builder::compatibleMode);
        boolean isOldVersion = config.getOptional(JdbcSourceOptions.QUERY).isPresent() && config.getOptional(JdbcSourceOptions.PARTITION_COLUMN).isPresent();
        builder.useDynamicSplitter(!isOldVersion);
        builder.stringSplitMode((StringSplitMode)((Object)config.get(JdbcSourceOptions.STRING_SPLIT_MODE)));
        builder.stringSplitModeCollate((String)config.get(JdbcSourceOptions.STRING_SPLIT_MODE_COLLATE));
        builder.splitSize((Integer)config.get(JdbcSourceOptions.SPLIT_SIZE));
        builder.splitEvenDistributionFactorUpperBound((Double)config.get(JdbcSourceOptions.SPLIT_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND));
        builder.splitEvenDistributionFactorLowerBound((Double)config.get(JdbcSourceOptions.SPLIT_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND));
        builder.splitSampleShardingThreshold((Integer)config.get(JdbcSourceOptions.SPLIT_SAMPLE_SHARDING_THRESHOLD));
        builder.splitInverseSamplingRate((Integer)config.get(JdbcSourceOptions.SPLIT_INVERSE_SAMPLING_RATE));
        builder.decimalTypeNarrowing((Boolean)config.get(JdbcSourceOptions.DECIMAL_TYPE_NARROWING));
        builder.handleBlobAsString((Boolean)config.get(JdbcSourceOptions.HANDLE_BLOB_AS_STRING));
        config.getOptional(JdbcSourceOptions.WHERE_CONDITION).ifPresent(whereConditionClause -> {
            if (!whereConditionClause.toLowerCase().startsWith("where")) {
                throw new IllegalArgumentException("The where condition clause must start with 'where'. value: " + whereConditionClause);
            }
            builder.whereConditionClause((String)whereConditionClause);
        });
        return builder.build();
    }

    JdbcSourceConfig(JdbcConnectionConfig jdbcConnectionConfig, List<JdbcSourceTableConfig> tableConfigList, String whereConditionClause, String compatibleMode, int fetchSize, boolean useDynamicSplitter, int splitSize, double splitEvenDistributionFactorUpperBound, double splitEvenDistributionFactorLowerBound, int splitSampleShardingThreshold, int splitInverseSamplingRate, boolean decimalTypeNarrowing, boolean handleBlobAsString, StringSplitMode stringSplitMode, String stringSplitModeCollate) {
        this.jdbcConnectionConfig = jdbcConnectionConfig;
        this.tableConfigList = tableConfigList;
        this.whereConditionClause = whereConditionClause;
        this.compatibleMode = compatibleMode;
        this.fetchSize = fetchSize;
        this.useDynamicSplitter = useDynamicSplitter;
        this.splitSize = splitSize;
        this.splitEvenDistributionFactorUpperBound = splitEvenDistributionFactorUpperBound;
        this.splitEvenDistributionFactorLowerBound = splitEvenDistributionFactorLowerBound;
        this.splitSampleShardingThreshold = splitSampleShardingThreshold;
        this.splitInverseSamplingRate = splitInverseSamplingRate;
        this.decimalTypeNarrowing = decimalTypeNarrowing;
        this.handleBlobAsString = handleBlobAsString;
        this.stringSplitMode = stringSplitMode;
        this.stringSplitModeCollate = stringSplitModeCollate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public JdbcConnectionConfig getJdbcConnectionConfig() {
        return this.jdbcConnectionConfig;
    }

    public List<JdbcSourceTableConfig> getTableConfigList() {
        return this.tableConfigList;
    }

    public String getWhereConditionClause() {
        return this.whereConditionClause;
    }

    public String getCompatibleMode() {
        return this.compatibleMode;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isUseDynamicSplitter() {
        return this.useDynamicSplitter;
    }

    public int getSplitSize() {
        return this.splitSize;
    }

    public double getSplitEvenDistributionFactorUpperBound() {
        return this.splitEvenDistributionFactorUpperBound;
    }

    public double getSplitEvenDistributionFactorLowerBound() {
        return this.splitEvenDistributionFactorLowerBound;
    }

    public int getSplitSampleShardingThreshold() {
        return this.splitSampleShardingThreshold;
    }

    public int getSplitInverseSamplingRate() {
        return this.splitInverseSamplingRate;
    }

    public boolean isDecimalTypeNarrowing() {
        return this.decimalTypeNarrowing;
    }

    public boolean isHandleBlobAsString() {
        return this.handleBlobAsString;
    }

    public StringSplitMode getStringSplitMode() {
        return this.stringSplitMode;
    }

    public String getStringSplitModeCollate() {
        return this.stringSplitModeCollate;
    }

    public void setJdbcConnectionConfig(JdbcConnectionConfig jdbcConnectionConfig) {
        this.jdbcConnectionConfig = jdbcConnectionConfig;
    }

    public void setTableConfigList(List<JdbcSourceTableConfig> tableConfigList) {
        this.tableConfigList = tableConfigList;
    }

    public void setWhereConditionClause(String whereConditionClause) {
        this.whereConditionClause = whereConditionClause;
    }

    public void setCompatibleMode(String compatibleMode) {
        this.compatibleMode = compatibleMode;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setUseDynamicSplitter(boolean useDynamicSplitter) {
        this.useDynamicSplitter = useDynamicSplitter;
    }

    public void setSplitSize(int splitSize) {
        this.splitSize = splitSize;
    }

    public void setSplitEvenDistributionFactorUpperBound(double splitEvenDistributionFactorUpperBound) {
        this.splitEvenDistributionFactorUpperBound = splitEvenDistributionFactorUpperBound;
    }

    public void setSplitEvenDistributionFactorLowerBound(double splitEvenDistributionFactorLowerBound) {
        this.splitEvenDistributionFactorLowerBound = splitEvenDistributionFactorLowerBound;
    }

    public void setSplitSampleShardingThreshold(int splitSampleShardingThreshold) {
        this.splitSampleShardingThreshold = splitSampleShardingThreshold;
    }

    public void setSplitInverseSamplingRate(int splitInverseSamplingRate) {
        this.splitInverseSamplingRate = splitInverseSamplingRate;
    }

    public void setDecimalTypeNarrowing(boolean decimalTypeNarrowing) {
        this.decimalTypeNarrowing = decimalTypeNarrowing;
    }

    public void setHandleBlobAsString(boolean handleBlobAsString) {
        this.handleBlobAsString = handleBlobAsString;
    }

    public void setStringSplitMode(StringSplitMode stringSplitMode) {
        this.stringSplitMode = stringSplitMode;
    }

    public void setStringSplitModeCollate(String stringSplitModeCollate) {
        this.stringSplitModeCollate = stringSplitModeCollate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSourceConfig)) {
            return false;
        }
        JdbcSourceConfig other = (JdbcSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFetchSize() != other.getFetchSize()) {
            return false;
        }
        if (this.isUseDynamicSplitter() != other.isUseDynamicSplitter()) {
            return false;
        }
        if (this.getSplitSize() != other.getSplitSize()) {
            return false;
        }
        if (Double.compare(this.getSplitEvenDistributionFactorUpperBound(), other.getSplitEvenDistributionFactorUpperBound()) != 0) {
            return false;
        }
        if (Double.compare(this.getSplitEvenDistributionFactorLowerBound(), other.getSplitEvenDistributionFactorLowerBound()) != 0) {
            return false;
        }
        if (this.getSplitSampleShardingThreshold() != other.getSplitSampleShardingThreshold()) {
            return false;
        }
        if (this.getSplitInverseSamplingRate() != other.getSplitInverseSamplingRate()) {
            return false;
        }
        if (this.isDecimalTypeNarrowing() != other.isDecimalTypeNarrowing()) {
            return false;
        }
        if (this.isHandleBlobAsString() != other.isHandleBlobAsString()) {
            return false;
        }
        JdbcConnectionConfig this$jdbcConnectionConfig = this.getJdbcConnectionConfig();
        JdbcConnectionConfig other$jdbcConnectionConfig = other.getJdbcConnectionConfig();
        if (this$jdbcConnectionConfig == null ? other$jdbcConnectionConfig != null : !this$jdbcConnectionConfig.equals(other$jdbcConnectionConfig)) {
            return false;
        }
        List<JdbcSourceTableConfig> this$tableConfigList = this.getTableConfigList();
        List<JdbcSourceTableConfig> other$tableConfigList = other.getTableConfigList();
        if (this$tableConfigList == null ? other$tableConfigList != null : !((Object)this$tableConfigList).equals(other$tableConfigList)) {
            return false;
        }
        String this$whereConditionClause = this.getWhereConditionClause();
        String other$whereConditionClause = other.getWhereConditionClause();
        if (this$whereConditionClause == null ? other$whereConditionClause != null : !this$whereConditionClause.equals(other$whereConditionClause)) {
            return false;
        }
        String this$compatibleMode = this.getCompatibleMode();
        String other$compatibleMode = other.getCompatibleMode();
        if (this$compatibleMode == null ? other$compatibleMode != null : !this$compatibleMode.equals(other$compatibleMode)) {
            return false;
        }
        StringSplitMode this$stringSplitMode = this.getStringSplitMode();
        StringSplitMode other$stringSplitMode = other.getStringSplitMode();
        if (this$stringSplitMode == null ? other$stringSplitMode != null : !((Object)((Object)this$stringSplitMode)).equals((Object)other$stringSplitMode)) {
            return false;
        }
        String this$stringSplitModeCollate = this.getStringSplitModeCollate();
        String other$stringSplitModeCollate = other.getStringSplitModeCollate();
        return !(this$stringSplitModeCollate == null ? other$stringSplitModeCollate != null : !this$stringSplitModeCollate.equals(other$stringSplitModeCollate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFetchSize();
        result = result * 59 + (this.isUseDynamicSplitter() ? 79 : 97);
        result = result * 59 + this.getSplitSize();
        long $splitEvenDistributionFactorUpperBound = Double.doubleToLongBits(this.getSplitEvenDistributionFactorUpperBound());
        result = result * 59 + (int)($splitEvenDistributionFactorUpperBound >>> 32 ^ $splitEvenDistributionFactorUpperBound);
        long $splitEvenDistributionFactorLowerBound = Double.doubleToLongBits(this.getSplitEvenDistributionFactorLowerBound());
        result = result * 59 + (int)($splitEvenDistributionFactorLowerBound >>> 32 ^ $splitEvenDistributionFactorLowerBound);
        result = result * 59 + this.getSplitSampleShardingThreshold();
        result = result * 59 + this.getSplitInverseSamplingRate();
        result = result * 59 + (this.isDecimalTypeNarrowing() ? 79 : 97);
        result = result * 59 + (this.isHandleBlobAsString() ? 79 : 97);
        JdbcConnectionConfig $jdbcConnectionConfig = this.getJdbcConnectionConfig();
        result = result * 59 + ($jdbcConnectionConfig == null ? 43 : $jdbcConnectionConfig.hashCode());
        List<JdbcSourceTableConfig> $tableConfigList = this.getTableConfigList();
        result = result * 59 + ($tableConfigList == null ? 43 : ((Object)$tableConfigList).hashCode());
        String $whereConditionClause = this.getWhereConditionClause();
        result = result * 59 + ($whereConditionClause == null ? 43 : $whereConditionClause.hashCode());
        String $compatibleMode = this.getCompatibleMode();
        result = result * 59 + ($compatibleMode == null ? 43 : $compatibleMode.hashCode());
        StringSplitMode $stringSplitMode = this.getStringSplitMode();
        result = result * 59 + ($stringSplitMode == null ? 43 : ((Object)((Object)$stringSplitMode)).hashCode());
        String $stringSplitModeCollate = this.getStringSplitModeCollate();
        result = result * 59 + ($stringSplitModeCollate == null ? 43 : $stringSplitModeCollate.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcSourceConfig(jdbcConnectionConfig=" + this.getJdbcConnectionConfig() + ", tableConfigList=" + this.getTableConfigList() + ", whereConditionClause=" + this.getWhereConditionClause() + ", compatibleMode=" + this.getCompatibleMode() + ", fetchSize=" + this.getFetchSize() + ", useDynamicSplitter=" + this.isUseDynamicSplitter() + ", splitSize=" + this.getSplitSize() + ", splitEvenDistributionFactorUpperBound=" + this.getSplitEvenDistributionFactorUpperBound() + ", splitEvenDistributionFactorLowerBound=" + this.getSplitEvenDistributionFactorLowerBound() + ", splitSampleShardingThreshold=" + this.getSplitSampleShardingThreshold() + ", splitInverseSamplingRate=" + this.getSplitInverseSamplingRate() + ", decimalTypeNarrowing=" + this.isDecimalTypeNarrowing() + ", handleBlobAsString=" + this.isHandleBlobAsString() + ", stringSplitMode=" + (Object)((Object)this.getStringSplitMode()) + ", stringSplitModeCollate=" + this.getStringSplitModeCollate() + ")";
    }

    public static class Builder {
        private JdbcConnectionConfig jdbcConnectionConfig;
        private List<JdbcSourceTableConfig> tableConfigList;
        private String whereConditionClause;
        private String compatibleMode;
        private int fetchSize;
        private boolean useDynamicSplitter;
        private int splitSize;
        private double splitEvenDistributionFactorUpperBound;
        private double splitEvenDistributionFactorLowerBound;
        private int splitSampleShardingThreshold;
        private int splitInverseSamplingRate;
        private boolean decimalTypeNarrowing;
        private boolean handleBlobAsString;
        private StringSplitMode stringSplitMode;
        private String stringSplitModeCollate;

        Builder() {
        }

        public Builder jdbcConnectionConfig(JdbcConnectionConfig jdbcConnectionConfig) {
            this.jdbcConnectionConfig = jdbcConnectionConfig;
            return this;
        }

        public Builder tableConfigList(List<JdbcSourceTableConfig> tableConfigList) {
            this.tableConfigList = tableConfigList;
            return this;
        }

        public Builder whereConditionClause(String whereConditionClause) {
            this.whereConditionClause = whereConditionClause;
            return this;
        }

        public Builder compatibleMode(String compatibleMode) {
            this.compatibleMode = compatibleMode;
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder useDynamicSplitter(boolean useDynamicSplitter) {
            this.useDynamicSplitter = useDynamicSplitter;
            return this;
        }

        public Builder splitSize(int splitSize) {
            this.splitSize = splitSize;
            return this;
        }

        public Builder splitEvenDistributionFactorUpperBound(double splitEvenDistributionFactorUpperBound) {
            this.splitEvenDistributionFactorUpperBound = splitEvenDistributionFactorUpperBound;
            return this;
        }

        public Builder splitEvenDistributionFactorLowerBound(double splitEvenDistributionFactorLowerBound) {
            this.splitEvenDistributionFactorLowerBound = splitEvenDistributionFactorLowerBound;
            return this;
        }

        public Builder splitSampleShardingThreshold(int splitSampleShardingThreshold) {
            this.splitSampleShardingThreshold = splitSampleShardingThreshold;
            return this;
        }

        public Builder splitInverseSamplingRate(int splitInverseSamplingRate) {
            this.splitInverseSamplingRate = splitInverseSamplingRate;
            return this;
        }

        public Builder decimalTypeNarrowing(boolean decimalTypeNarrowing) {
            this.decimalTypeNarrowing = decimalTypeNarrowing;
            return this;
        }

        public Builder handleBlobAsString(boolean handleBlobAsString) {
            this.handleBlobAsString = handleBlobAsString;
            return this;
        }

        public Builder stringSplitMode(StringSplitMode stringSplitMode) {
            this.stringSplitMode = stringSplitMode;
            return this;
        }

        public Builder stringSplitModeCollate(String stringSplitModeCollate) {
            this.stringSplitModeCollate = stringSplitModeCollate;
            return this;
        }

        public JdbcSourceConfig build() {
            return new JdbcSourceConfig(this.jdbcConnectionConfig, this.tableConfigList, this.whereConditionClause, this.compatibleMode, this.fetchSize, this.useDynamicSplitter, this.splitSize, this.splitEvenDistributionFactorUpperBound, this.splitEvenDistributionFactorLowerBound, this.splitSampleShardingThreshold, this.splitInverseSamplingRate, this.decimalTypeNarrowing, this.handleBlobAsString, this.stringSplitMode, this.stringSplitModeCollate);
        }

        public String toString() {
            return "JdbcSourceConfig.Builder(jdbcConnectionConfig=" + this.jdbcConnectionConfig + ", tableConfigList=" + this.tableConfigList + ", whereConditionClause=" + this.whereConditionClause + ", compatibleMode=" + this.compatibleMode + ", fetchSize=" + this.fetchSize + ", useDynamicSplitter=" + this.useDynamicSplitter + ", splitSize=" + this.splitSize + ", splitEvenDistributionFactorUpperBound=" + this.splitEvenDistributionFactorUpperBound + ", splitEvenDistributionFactorLowerBound=" + this.splitEvenDistributionFactorLowerBound + ", splitSampleShardingThreshold=" + this.splitSampleShardingThreshold + ", splitInverseSamplingRate=" + this.splitInverseSamplingRate + ", decimalTypeNarrowing=" + this.decimalTypeNarrowing + ", handleBlobAsString=" + this.handleBlobAsString + ", stringSplitMode=" + (Object)((Object)this.stringSplitMode) + ", stringSplitModeCollate=" + this.stringSplitModeCollate + ")";
        }
    }
}

