/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.cdc.base.option.JdbcSourceOptions;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.apache.seatunnel.connectors.cdc.base.utils.CatalogTableUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.option.PostgresOptions;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.PostgresIncrementalSource;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.PostgresSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcCommonOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class PostgresIncrementalSourceFactory
implements TableSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(PostgresIncrementalSourceFactory.class);

    public String factoryIdentifier() {
        return "Postgres-CDC";
    }

    public OptionRule optionRule() {
        return JdbcSourceOptions.getBaseRule().required(new Option[]{JdbcSourceOptions.USERNAME, JdbcSourceOptions.PASSWORD, JdbcCommonOptions.URL}).exclusive(new Option[]{ConnectorCommonOptions.TABLE_NAMES, ConnectorCommonOptions.TABLE_PATTERN}).optional(new Option[]{JdbcSourceOptions.DATABASE_NAMES, JdbcSourceOptions.SERVER_TIME_ZONE, JdbcSourceOptions.CONNECT_TIMEOUT_MS, JdbcSourceOptions.CONNECT_MAX_RETRIES, JdbcSourceOptions.CONNECTION_POOL_SIZE, PostgresOptions.DECODING_PLUGIN_NAME, PostgresOptions.SLOT_NAME, JdbcSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND, JdbcSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND, JdbcSourceOptions.SAMPLE_SHARDING_THRESHOLD, JdbcSourceOptions.TABLE_NAMES_CONFIG}).optional(new Option[]{PostgresSourceOptions.STARTUP_MODE, PostgresSourceOptions.STOP_MODE}).conditional(PostgresSourceOptions.STARTUP_MODE, (Object)StartupMode.INITIAL, new Option[]{JdbcSourceOptions.EXACTLY_ONCE}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return PostgresIncrementalSource.class;
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> {
            try {
                Class.forName("org.postgresql.Driver");
            }
            catch (Exception e) {
                log.warn("Failed to load JDBC driver {}", (Object)"org.postgresql.Driver", (Object)e);
            }
            List catalogTables = CatalogTableUtil.getCatalogTables((ReadonlyConfig)context.getOptions(), (ClassLoader)context.getClassLoader());
            Optional tableConfigs = context.getOptions().getOptional(JdbcSourceOptions.TABLE_NAMES_CONFIG);
            if (tableConfigs.isPresent()) {
                catalogTables = CatalogTableUtils.mergeCatalogTableConfig((List)catalogTables, (List)((List)tableConfigs.get()), s -> TablePath.of((String)s, (boolean)true));
            }
            return new PostgresIncrementalSource(context.getOptions(), catalogTables);
        };
    }
}

