/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlServerTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlserverTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(SqlserverTypeMapper.class);

    @Override
    public Column mappingColumn(BasicTypeDefine typeDefine) {
        return SqlServerTypeConverter.INSTANCE.convert(typeDefine);
    }

    @Override
    public Column mappingColumn(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnName = metadata.getColumnLabel(colIndex);
        String nativeType = metadata.getColumnTypeName(colIndex);
        int isNullable = metadata.isNullable(colIndex);
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        if ("float".equalsIgnoreCase(nativeType) && precision == 15) {
            precision = 53;
        } else if (Arrays.asList("nchar", "nvarchar").contains(nativeType)) {
            precision *= 2;
        }
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).columnType(nativeType).dataType(nativeType).nullable(isNullable == 1).length(Long.valueOf(precision)).precision(Long.valueOf(precision)).scale(Integer.valueOf(scale)).build();
        return this.mappingColumn(typeDefine);
    }
}

