/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.postgres.utils;

import io.debezium.connector.postgresql.CustomPostgresValueConverter;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import java.nio.charset.Charset;
import java.time.ZoneId;

public class PostgresConnectionUtils {
    public static PostgresConnection.PostgresValueConverterBuilder newPostgresValueConverterBuilder(PostgresConnectorConfig config, String connectionUsage, ZoneId zoneId) {
        try (PostgresConnection heartbeatConnection = new PostgresConnection(config.getJdbcConfig(), connectionUsage);){
            Charset databaseCharset = heartbeatConnection.getDatabaseCharset();
            PostgresConnection.PostgresValueConverterBuilder postgresValueConverterBuilder = typeRegistry -> CustomPostgresValueConverter.of(config, databaseCharset, typeRegistry, zoneId);
            return postgresValueConverterBuilder;
        }
    }

    public static PostgresConnection.PostgresValueConverterBuilder newPostgresValueConverterBuilder(PostgresConnectorConfig config, String connectionUsage, String serverTimezone) {
        try (PostgresConnection heartbeatConnection = new PostgresConnection(config.getJdbcConfig(), connectionUsage);){
            Charset databaseCharset = heartbeatConnection.getDatabaseCharset();
            PostgresConnection.PostgresValueConverterBuilder postgresValueConverterBuilder = typeRegistry -> CustomPostgresValueConverter.of(config, databaseCharset, typeRegistry, ZoneId.of(serverTimezone));
            return postgresValueConverterBuilder;
        }
    }
}

