/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.br;

import java.util.Iterator;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.SstFileReader;
import org.rocksdb.SstFileReaderIterator;
import org.tikv.br.KVDecoder;
import org.tikv.br.SSTIterator;
import org.tikv.common.util.Pair;
import org.tikv.shade.com.google.protobuf.ByteString;

public class SSTDecoder {
    private final String filePath;
    private final KVDecoder kvDecoder;
    private final Options options;
    private final ReadOptions readOptions;
    private SstFileReader sstFileReader;
    private SstFileReaderIterator iterator;

    public SSTDecoder(String sstFilePath, KVDecoder kvDecoder) {
        this.filePath = sstFilePath;
        this.kvDecoder = kvDecoder;
        this.options = new Options();
        this.readOptions = new ReadOptions();
    }

    public SSTDecoder(String filePath, KVDecoder kvDecoder, Options options, ReadOptions readOptions) {
        this.filePath = filePath;
        this.kvDecoder = kvDecoder;
        this.options = options;
        this.readOptions = readOptions;
    }

    public synchronized Iterator<Pair<ByteString, ByteString>> getIterator() throws RocksDBException {
        if (this.sstFileReader != null || this.iterator != null) {
            throw new RocksDBException("File already opened!");
        }
        this.sstFileReader = new SstFileReader(new Options());
        this.sstFileReader.open(this.filePath);
        this.iterator = this.sstFileReader.newIterator(new ReadOptions());
        return new SSTIterator(this.iterator, this.kvDecoder);
    }

    public synchronized void close() {
        try {
            if (this.iterator != null) {
                this.iterator.close();
            }
        }
        finally {
            this.iterator = null;
        }
        try {
            if (this.sstFileReader != null) {
                this.sstFileReader.close();
            }
        }
        finally {
            this.sstFileReader = null;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Options getOptions() {
        return this.options;
    }

    public ReadOptions getReadOptions() {
        return this.readOptions;
    }
}

