/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils;

import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class CollectionDiscoveryUtils {
    public static final Bson ADD_NS_FIELD = BsonDocument.parse(String.format("{'$addFields': {'%s': {'$concat': ['$ns.db', '.', '$ns.coll']}}}", "_ns_"));

    private CollectionDiscoveryUtils() {
    }

    @Nonnull
    public static List<String> databaseNames(@Nonnull MongoClient mongoClient, Predicate<String> databaseFilter) {
        ArrayList databaseNames = new ArrayList();
        return ((List)mongoClient.listDatabaseNames().into(databaseNames)).stream().filter(databaseFilter).collect(Collectors.toList());
    }

    @Nonnull
    public static List<String> collectionNames(MongoClient mongoClient, List<String> databaseNames, Predicate<String> collectionFilter) {
        return CollectionDiscoveryUtils.collectionNames(mongoClient, databaseNames, collectionFilter, String::toString);
    }

    @Nonnull
    public static <T> List<T> collectionNames(MongoClient mongoClient, @Nonnull List<String> databaseNames, Predicate<String> collectionFilter, Function<String, T> conversion) {
        ArrayList collectionNames = new ArrayList();
        for (String dbName : databaseNames) {
            MongoDatabase db = mongoClient.getDatabase(dbName);
            StreamSupport.stream(db.listCollectionNames().spliterator(), false).map(collName -> dbName + "." + collName).filter(collectionFilter).map(conversion).forEach(collectionNames::add);
        }
        return collectionNames;
    }

    private static Predicate<String> stringListFilter(Predicate<String> filter, List<String> stringList) {
        if (CollectionUtils.isNotEmpty(stringList)) {
            List<Pattern> databasePatterns = CollectionDiscoveryUtils.includeListAsPatterns(stringList);
            filter = filter.and(CollectionDiscoveryUtils.anyMatch(databasePatterns));
        }
        return filter;
    }

    public static Predicate<String> databaseFilter(List<String> databaseList) {
        return CollectionDiscoveryUtils.stringListFilter(CollectionDiscoveryUtils::isNotBuiltInDatabase, databaseList);
    }

    public static Predicate<String> collectionsFilter(List<String> collectionList) {
        return CollectionDiscoveryUtils.stringListFilter(CollectionDiscoveryUtils::isNotBuiltInCollections, collectionList);
    }

    @Nonnull
    public static Predicate<String> anyMatch(List<Pattern> patterns) {
        return s -> patterns.stream().anyMatch(p -> p.matcher((CharSequence)s).matches());
    }

    public static Pattern includeListAsFlatPattern(List<String> includeList) {
        return CollectionDiscoveryUtils.includeListAsFlatPattern(includeList, CollectionDiscoveryUtils::completionPattern);
    }

    public static Pattern includeListAsFlatPattern(List<String> includeList, Function<String, Pattern> conversion) {
        if (includeList == null || includeList.isEmpty()) {
            return null;
        }
        String flatPatternLiteral = includeList.stream().map(conversion).map(Pattern::pattern).collect(Collectors.joining("|"));
        return Pattern.compile(flatPatternLiteral);
    }

    public static List<Pattern> includeListAsPatterns(List<String> includeList) {
        return CollectionDiscoveryUtils.includeListAsPatterns(includeList, CollectionDiscoveryUtils::completionPattern);
    }

    public static List<Pattern> includeListAsPatterns(List<String> includeList, Function<String, Pattern> conversion) {
        return includeList != null && !includeList.isEmpty() ? includeList.stream().map(conversion).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static boolean isNotBuiltInCollections(String fullName) {
        if (fullName == null) {
            return false;
        }
        MongoNamespace namespace = new MongoNamespace(fullName);
        return CollectionDiscoveryUtils.isNotBuiltInDatabase(namespace.getDatabaseName()) && !namespace.getCollectionName().startsWith("system.");
    }

    public static boolean isNotBuiltInDatabase(String databaseName) {
        if (databaseName == null) {
            return false;
        }
        return !"local".equals(databaseName) && !"admin".equals(databaseName) && !"config".equals(databaseName);
    }

    @Nonnull
    public static Pattern completionPattern(@Nonnull String pattern) {
        if (pattern.startsWith("^") && pattern.endsWith("$")) {
            return Pattern.compile(pattern);
        }
        return Pattern.compile("^(" + pattern + ")$");
    }

    public static class CollectionDiscoveryInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> discoveredDatabases;
        private final List<String> discoveredCollections;

        public List<String> getDiscoveredDatabases() {
            return this.discoveredDatabases;
        }

        public List<String> getDiscoveredCollections() {
            return this.discoveredCollections;
        }

        public CollectionDiscoveryInfo(List<String> discoveredDatabases, List<String> discoveredCollections) {
            this.discoveredDatabases = discoveredDatabases;
            this.discoveredCollections = discoveredCollections;
        }
    }
}

