/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.offset;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.MongodbRecordUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.ResumeToken;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public class ChangeStreamOffset
extends Offset {
    private static final long serialVersionUID = 1L;
    public static final ChangeStreamOffset NO_STOPPING_OFFSET = new ChangeStreamOffset(MongodbRecordUtils.maximumBsonTimestamp());

    public ChangeStreamOffset(Map<String, String> offset) {
        this.offset = offset;
    }

    public ChangeStreamOffset(BsonDocument resumeToken) {
        Objects.requireNonNull(resumeToken);
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put("timestamp", String.valueOf(ResumeToken.decodeTimestamp(resumeToken).getValue()));
        offsetMap.put("resumeToken", resumeToken.toJson());
        this.offset = offsetMap;
    }

    public ChangeStreamOffset(BsonTimestamp timestamp) {
        Objects.requireNonNull(timestamp);
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put("timestamp", String.valueOf(timestamp.getValue()));
        offsetMap.put("resumeToken", null);
        this.offset = offsetMap;
    }

    public void updatePosition(BsonDocument resumeToken) {
        Objects.requireNonNull(resumeToken);
        this.offset.put("timestamp", String.valueOf(ResumeToken.decodeTimestamp(resumeToken).getValue()));
        this.offset.put("resumeToken", resumeToken.toJson());
    }

    @Nullable
    public BsonDocument getResumeToken() {
        String resumeTokenJson = (String)this.offset.get("resumeToken");
        return Optional.ofNullable(resumeTokenJson).map(BsonDocument::parse).orElse(null);
    }

    public BsonTimestamp getTimestamp() {
        long timestamp = System.currentTimeMillis();
        if (this.offset.get("timestamp") != null) {
            timestamp = Long.parseLong((String)this.offset.get("timestamp"));
        }
        return new BsonTimestamp(timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeStreamOffset)) {
            return false;
        }
        ChangeStreamOffset that = (ChangeStreamOffset)((Object)o);
        return this.offset.equals(that.offset);
    }

    public int compareTo(Offset offset) {
        if (offset == null) {
            return -1;
        }
        ChangeStreamOffset that = (ChangeStreamOffset)offset;
        return this.getTimestamp().compareTo(that.getTimestamp());
    }
}

