/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.config;

import java.util.List;
import org.apache.seatunnel.connectors.cdc.base.config.SourceConfig;
import org.apache.seatunnel.connectors.cdc.base.config.StartupConfig;
import org.apache.seatunnel.connectors.cdc.base.config.StopConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.MongodbUtils;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class MongodbSourceConfig
implements SourceConfig {
    private static final long serialVersionUID = 1L;
    private final String hosts;
    private final String username;
    private final String password;
    private final List<String> databaseList;
    private final List<String> collectionList;
    private final String connectionString;
    private final int batchSize;
    private final int pollAwaitTimeMillis;
    private final int pollMaxBatchSize;
    private final boolean updateLookup;
    private final StartupConfig startupOptions;
    private final StopConfig stopOptions;
    private final int heartbeatIntervalMillis;
    private final int splitMetaGroupSize;
    private final int splitSizeMB;
    private final boolean exactlyOnce;

    MongodbSourceConfig(String hosts, String username, String password, List<String> databaseList, List<String> collectionList, String connectionOptions, int batchSize, int pollAwaitTimeMillis, int pollMaxBatchSize, boolean updateLookup, StartupConfig startupOptions, StopConfig stopOptions, int heartbeatIntervalMillis, int splitMetaGroupSize, int splitSizeMB, boolean exactlyOnce) {
        this.hosts = (String)Preconditions.checkNotNull((Object)hosts);
        this.username = username;
        this.password = password;
        this.databaseList = databaseList;
        this.collectionList = collectionList;
        this.connectionString = MongodbUtils.buildConnectionString(username, password, hosts, connectionOptions).getConnectionString();
        this.batchSize = batchSize;
        this.pollAwaitTimeMillis = pollAwaitTimeMillis;
        this.pollMaxBatchSize = pollMaxBatchSize;
        this.updateLookup = updateLookup;
        this.startupOptions = startupOptions;
        this.stopOptions = stopOptions;
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.splitSizeMB = splitSizeMB;
        this.exactlyOnce = exactlyOnce;
    }

    public StartupConfig getStartupConfig() {
        return this.startupOptions;
    }

    public StopConfig getStopConfig() {
        return this.stopOptions;
    }

    public int getSplitSize() {
        return this.splitSizeMB;
    }

    public boolean isExactlyOnce() {
        return this.exactlyOnce;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getDatabaseList() {
        return this.databaseList;
    }

    public List<String> getCollectionList() {
        return this.collectionList;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getPollAwaitTimeMillis() {
        return this.pollAwaitTimeMillis;
    }

    public int getPollMaxBatchSize() {
        return this.pollMaxBatchSize;
    }

    public boolean isUpdateLookup() {
        return this.updateLookup;
    }

    public StartupConfig getStartupOptions() {
        return this.startupOptions;
    }

    public StopConfig getStopOptions() {
        return this.stopOptions;
    }

    public int getHeartbeatIntervalMillis() {
        return this.heartbeatIntervalMillis;
    }

    public int getSplitMetaGroupSize() {
        return this.splitMetaGroupSize;
    }

    public int getSplitSizeMB() {
        return this.splitSizeMB;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongodbSourceConfig)) {
            return false;
        }
        MongodbSourceConfig other = (MongodbSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getPollAwaitTimeMillis() != other.getPollAwaitTimeMillis()) {
            return false;
        }
        if (this.getPollMaxBatchSize() != other.getPollMaxBatchSize()) {
            return false;
        }
        if (this.isUpdateLookup() != other.isUpdateLookup()) {
            return false;
        }
        if (this.getHeartbeatIntervalMillis() != other.getHeartbeatIntervalMillis()) {
            return false;
        }
        if (this.getSplitMetaGroupSize() != other.getSplitMetaGroupSize()) {
            return false;
        }
        if (this.getSplitSizeMB() != other.getSplitSizeMB()) {
            return false;
        }
        if (this.isExactlyOnce() != other.isExactlyOnce()) {
            return false;
        }
        String this$hosts = this.getHosts();
        String other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        List<String> this$databaseList = this.getDatabaseList();
        List<String> other$databaseList = other.getDatabaseList();
        if (this$databaseList == null ? other$databaseList != null : !((Object)this$databaseList).equals(other$databaseList)) {
            return false;
        }
        List<String> this$collectionList = this.getCollectionList();
        List<String> other$collectionList = other.getCollectionList();
        if (this$collectionList == null ? other$collectionList != null : !((Object)this$collectionList).equals(other$collectionList)) {
            return false;
        }
        String this$connectionString = this.getConnectionString();
        String other$connectionString = other.getConnectionString();
        if (this$connectionString == null ? other$connectionString != null : !this$connectionString.equals(other$connectionString)) {
            return false;
        }
        StartupConfig this$startupOptions = this.getStartupOptions();
        StartupConfig other$startupOptions = other.getStartupOptions();
        if (this$startupOptions == null ? other$startupOptions != null : !this$startupOptions.equals(other$startupOptions)) {
            return false;
        }
        StopConfig this$stopOptions = this.getStopOptions();
        StopConfig other$stopOptions = other.getStopOptions();
        return !(this$stopOptions == null ? other$stopOptions != null : !this$stopOptions.equals(other$stopOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongodbSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getPollAwaitTimeMillis();
        result = result * 59 + this.getPollMaxBatchSize();
        result = result * 59 + (this.isUpdateLookup() ? 79 : 97);
        result = result * 59 + this.getHeartbeatIntervalMillis();
        result = result * 59 + this.getSplitMetaGroupSize();
        result = result * 59 + this.getSplitSizeMB();
        result = result * 59 + (this.isExactlyOnce() ? 79 : 97);
        String $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : $hosts.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        List<String> $databaseList = this.getDatabaseList();
        result = result * 59 + ($databaseList == null ? 43 : ((Object)$databaseList).hashCode());
        List<String> $collectionList = this.getCollectionList();
        result = result * 59 + ($collectionList == null ? 43 : ((Object)$collectionList).hashCode());
        String $connectionString = this.getConnectionString();
        result = result * 59 + ($connectionString == null ? 43 : $connectionString.hashCode());
        StartupConfig $startupOptions = this.getStartupOptions();
        result = result * 59 + ($startupOptions == null ? 43 : $startupOptions.hashCode());
        StopConfig $stopOptions = this.getStopOptions();
        result = result * 59 + ($stopOptions == null ? 43 : $stopOptions.hashCode());
        return result;
    }
}

