/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.metrics;

import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.metrics.MongoDbSnapshotChangeEventSourceMetrics;
import io.debezium.connector.mongodb.metrics.MongoDbStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetrics;
import io.debezium.pipeline.metrics.StreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;

public class MongoDbChangeEventSourceMetricsFactory
extends DefaultChangeEventSourceMetricsFactory<MongoDbPartition> {
    private final int maxTasks;

    public MongoDbChangeEventSourceMetricsFactory(MongoDbConnectorConfig connectorConfig) {
        this.maxTasks = connectorConfig.getConfig().getInteger("tasks.max", 1);
    }

    public <T extends CdcSourceTaskContext> SnapshotChangeEventSourceMetrics<MongoDbPartition> getSnapshotMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider eventMetadataProvider) {
        return new MongoDbSnapshotChangeEventSourceMetrics(taskContext, changeEventQueueMetrics, eventMetadataProvider, this.maxTasks);
    }

    public <T extends CdcSourceTaskContext> StreamingChangeEventSourceMetrics<MongoDbPartition> getStreamingMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider eventMetadataProvider) {
        return new MongoDbStreamingChangeEventSourceMetrics(taskContext, changeEventQueueMetrics, eventMetadataProvider, this.maxTasks);
    }
}

