/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.jmx.internal;

import com.mongodb.kafka.connect.util.jmx.internal.Metric;
import com.mongodb.kafka.connect.util.jmx.internal.MetricValue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class AdditiveMetric
implements Metric {
    private final String name;
    private final String unit;
    private final long[] limits;
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong total = new AtomicLong();
    private final AtomicLong[] bins;

    public AdditiveMetric(String name, String unit, long[] limits) {
        this.name = name;
        this.unit = unit;
        this.limits = limits;
        this.bins = new AtomicLong[limits.length];
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i] = new AtomicLong();
        }
    }

    @Override
    public void sample(long n) {
        this.count.addAndGet(1L);
        for (int i = 0; i < this.bins.length; ++i) {
            if (n <= this.limits[i]) continue;
            this.bins[i].addAndGet(1L);
        }
        this.total.addAndGet(n);
    }

    @Override
    public void emit(Consumer<MetricValue> consumer) {
        consumer.accept(new MetricValue.TotalMetricValue(this.name, this.count::get));
        consumer.accept(new MetricValue.TotalMetricValue(this.name + "-duration-" + this.unit, this.total::get));
        for (int i = 0; i < this.bins.length; ++i) {
            int finalI = i;
            consumer.accept(new MetricValue.TotalMetricValue(this.name + "-duration-over-" + this.limits[i] + "-" + this.unit, () -> this.bins[finalI].get()));
        }
    }
}

