/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoClient;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.base.source.split.SnapshotSplit;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SampleBucketSplitStrategy;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SingleSplitStrategy;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SplitContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SplitStrategy;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.ChunkUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.MongodbUtils;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonMinKey;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SplitVectorSplitStrategy implements SplitStrategy
{
    INSTANCE;

    private static final Logger log;

    @Override
    public Collection<SnapshotSplit> split(@Nonnull SplitContext splitContext) {
        BsonDocument splitResult;
        MongoClient mongoClient = splitContext.getMongoClient();
        TableId collectionId = splitContext.getCollectionId();
        int chunkSizeMB = splitContext.getChunkSizeMB();
        BsonDocument keyPattern = new BsonDocument("_id", new BsonInt32(1));
        try {
            splitResult = MongodbUtils.splitVector(mongoClient, collectionId, keyPattern, chunkSizeMB);
        }
        catch (MongoCommandException e) {
            if (e.getErrorCode() == 13) {
                log.warn("Unauthorized to execute splitVector command: {}, fallback to SampleSplitter", (Object)e.getErrorMessage());
            } else {
                log.warn("Execute splitVector command failed: {}, fallback to SampleSplitter", (Object)e.getErrorMessage());
            }
            return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
        }
        if (!MongodbUtils.isCommandSucceed(splitResult)) {
            log.warn("Could not calculate standalone splits: {}, fallback to SampleSplitter", (Object)splitResult.getString("errmsg"));
            return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
        }
        BsonArray splitKeys = splitResult.getArray("splitKeys");
        if (CollectionUtils.isEmpty((Collection)splitKeys)) {
            return SingleSplitStrategy.INSTANCE.split(splitContext);
        }
        SeaTunnelRowType rowType = this.shardKeysToRowType(Collections.singleton("_id"));
        ArrayList<SnapshotSplit> snapshotSplits = new ArrayList<SnapshotSplit>(splitKeys.size() + 1);
        BsonValue lowerValue = new BsonMinKey();
        for (int i = 0; i < splitKeys.size(); ++i) {
            BsonValue splitKeyValue = splitKeys.get(i).asDocument().get("_id");
            snapshotSplits.add(new SnapshotSplit(this.splitId(collectionId, i), collectionId, rowType, ChunkUtils.boundOfId(lowerValue), ChunkUtils.boundOfId(splitKeyValue)));
            lowerValue = splitKeyValue;
        }
        SnapshotSplit lastSplit = new SnapshotSplit(this.splitId(collectionId, splitKeys.size()), collectionId, rowType, ChunkUtils.boundOfId(lowerValue), ChunkUtils.maxUpperBoundOfId());
        snapshotSplits.add(lastSplit);
        return snapshotSplits;
    }

    static {
        log = LoggerFactory.getLogger(SplitVectorSplitStrategy.class);
    }
}

