/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.config;

import java.util.List;
import java.util.Objects;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.cdc.base.config.SourceConfig;
import org.apache.seatunnel.connectors.cdc.base.config.StartupConfig;
import org.apache.seatunnel.connectors.cdc.base.config.StopConfig;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.apache.seatunnel.connectors.cdc.base.option.StopMode;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.config.MongodbSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.config.MongodbSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.exception.MongodbConnectorException;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class MongodbSourceConfigProvider {
    private MongodbSourceConfigProvider() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements SourceConfig.Factory<MongodbSourceConfig> {
        private String hosts;
        private String username;
        private String password;
        private List<String> databaseList;
        private List<String> collectionList;
        private String connectionOptions;
        private int batchSize = (Integer)MongodbSourceOptions.BATCH_SIZE.defaultValue();
        private int pollAwaitTimeMillis = (Integer)MongodbSourceOptions.POLL_AWAIT_TIME_MILLIS.defaultValue();
        private int pollMaxBatchSize = (Integer)MongodbSourceOptions.POLL_MAX_BATCH_SIZE.defaultValue();
        private StartupConfig startupOptions;
        private StopConfig stopOptions;
        private int heartbeatIntervalMillis = (Integer)MongodbSourceOptions.HEARTBEAT_INTERVAL_MILLIS.defaultValue();
        private int splitMetaGroupSize = 2;
        private int splitSizeMB = (Integer)MongodbSourceOptions.INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB.defaultValue();

        public Builder hosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public Builder connectionOptions(String connectionOptions) {
            this.connectionOptions = connectionOptions;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder databaseList(List<String> databases) {
            this.databaseList = databases;
            return this;
        }

        public Builder collectionList(List<String> collections) {
            this.collectionList = collections;
            return this;
        }

        public Builder batchSize(int batchSize) {
            Preconditions.checkArgument((batchSize >= 0 ? 1 : 0) != 0);
            this.batchSize = batchSize;
            return this;
        }

        public Builder pollAwaitTimeMillis(int pollAwaitTimeMillis) {
            Preconditions.checkArgument((pollAwaitTimeMillis > 0 ? 1 : 0) != 0);
            this.pollAwaitTimeMillis = pollAwaitTimeMillis;
            return this;
        }

        public Builder pollMaxBatchSize(int pollMaxBatchSize) {
            Preconditions.checkArgument((pollMaxBatchSize > 0 ? 1 : 0) != 0);
            this.pollMaxBatchSize = pollMaxBatchSize;
            return this;
        }

        public Builder startupOptions(StartupConfig startupOptions) {
            this.startupOptions = Objects.requireNonNull(startupOptions);
            if (startupOptions.getStartupMode() != StartupMode.INITIAL && startupOptions.getStartupMode() != StartupMode.TIMESTAMP) {
                throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Unsupported startup mode " + (Object)((Object)startupOptions.getStartupMode()));
            }
            return this;
        }

        public Builder stopOptions(StopConfig stopOptions) {
            this.stopOptions = Objects.requireNonNull(stopOptions);
            if (stopOptions.getStopMode() != StopMode.NEVER) {
                throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, String.format("The %s mode is not supported.", new Object[]{stopOptions.getStopMode()}));
            }
            return this;
        }

        public Builder heartbeatIntervalMillis(int heartbeatIntervalMillis) {
            Preconditions.checkArgument((heartbeatIntervalMillis >= 0 ? 1 : 0) != 0);
            this.heartbeatIntervalMillis = heartbeatIntervalMillis;
            return this;
        }

        public Builder splitSizeMB(int splitSizeMB) {
            Preconditions.checkArgument((splitSizeMB > 0 ? 1 : 0) != 0);
            this.splitSizeMB = splitSizeMB;
            return this;
        }

        public Builder splitMetaGroupSize(int splitMetaGroupSize) {
            this.splitMetaGroupSize = splitMetaGroupSize;
            return this;
        }

        public Builder validate() {
            Preconditions.checkNotNull((Object)this.hosts, (Object)"hosts must be provided");
            return this;
        }

        @Override
        public MongodbSourceConfig create(int subtask) {
            boolean updateLookup = true;
            return new MongodbSourceConfig(this.hosts, this.username, this.password, this.databaseList, this.collectionList, this.connectionOptions, this.batchSize, this.pollAwaitTimeMillis, this.pollMaxBatchSize, updateLookup, this.startupOptions, this.stopOptions, this.heartbeatIntervalMillis, this.splitMetaGroupSize, this.splitSizeMB);
        }
    }
}

