/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.function.Predicates;
import io.debezium.util.Collect;
import java.util.Set;
import java.util.function.Predicate;

public final class Filters {
    protected static final Set<String> BUILT_IN_DB_NAMES = Collect.unmodifiableSet("local", "admin", "config");
    private final Predicate<String> databaseFilter;
    private final Predicate<CollectionId> collectionFilter;
    private final FieldSelector fieldSelector;

    public Filters(Configuration config) {
        String dbIncludeList = config.getFallbackStringProperty(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST, MongoDbConnectorConfig.DATABASE_WHITELIST);
        String dbExcludeList = config.getFallbackStringProperty(MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST, MongoDbConnectorConfig.DATABASE_BLACKLIST);
        this.databaseFilter = dbIncludeList != null && !dbIncludeList.trim().isEmpty() ? Predicates.includes(dbIncludeList) : (dbExcludeList != null && !dbExcludeList.trim().isEmpty() ? Predicates.excludes(dbExcludeList) : db -> true);
        String collectionIncludeList = config.getFallbackStringProperty(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, MongoDbConnectorConfig.COLLECTION_WHITELIST);
        String collectionExcludeList = config.getFallbackStringProperty(MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST, MongoDbConnectorConfig.COLLECTION_BLACKLIST);
        Predicate<CollectionId> collectionFilter = collectionIncludeList != null && !collectionIncludeList.trim().isEmpty() ? Predicates.includes(collectionIncludeList, CollectionId::namespace) : (collectionExcludeList != null && !collectionExcludeList.trim().isEmpty() ? Predicates.excludes(collectionExcludeList, CollectionId::namespace) : id -> true);
        Predicate<CollectionId> isNotBuiltIn = this::isNotBuiltIn;
        this.collectionFilter = isNotBuiltIn.and(collectionFilter);
        this.fieldSelector = FieldSelector.builder().excludeFields(config.getFallbackStringProperty(MongoDbConnectorConfig.FIELD_EXCLUDE_LIST, MongoDbConnectorConfig.FIELD_BLACKLIST)).renameFields(config.getString(MongoDbConnectorConfig.FIELD_RENAMES)).build();
    }

    public Predicate<String> databaseFilter() {
        return this.databaseFilter;
    }

    public Predicate<CollectionId> collectionFilter() {
        return this.collectionFilter;
    }

    public FieldSelector.FieldFilter fieldFilterFor(CollectionId id) {
        return this.fieldSelector.fieldFilterFor(id);
    }

    protected boolean isNotBuiltIn(CollectionId id) {
        return !BUILT_IN_DB_NAMES.contains(id.dbName());
    }
}

