/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.id.strategy;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.AllowListValueProjector;
import com.mongodb.kafka.connect.sink.processor.BlockListValueProjector;
import com.mongodb.kafka.connect.sink.processor.field.projection.FieldProjector;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class PartialValueStrategy
implements IdStrategy {
    private FieldProjector fieldProjector;

    @Override
    public BsonValue generateId(SinkDocument doc, SinkRecord orig) {
        SinkDocument clone = doc.clone();
        this.fieldProjector.process(clone, orig);
        return clone.getValueDoc().orElseGet(BsonDocument::new);
    }

    public FieldProjector getFieldProjector() {
        return this.fieldProjector;
    }

    @Override
    public void configure(MongoSinkTopicConfig config) {
        MongoSinkTopicConfig.FieldProjectionType valueProjectionType = MongoSinkTopicConfig.FieldProjectionType.valueOf(ConfigHelper.getOverrideOrDefault(config, "document.id.strategy.partial.value.projection.type", "value.projection.type").toUpperCase());
        String fieldList = ConfigHelper.getOverrideOrDefault(config, "document.id.strategy.partial.value.projection.list", "value.projection.list");
        switch (valueProjectionType) {
            case BLACKLIST: 
            case BLOCKLIST: {
                this.fieldProjector = new BlockListValueProjector(config, fieldList);
                break;
            }
            case ALLOWLIST: 
            case WHITELIST: {
                this.fieldProjector = new AllowListValueProjector(config, fieldList);
                break;
            }
            default: {
                throw new ConnectConfigException("document.id.strategy", this.getClass().getName(), String.format("Invalid %s value. It should be set to either %s or %s", new Object[]{"value.projection.type", MongoSinkTopicConfig.FieldProjectionType.BLOCKLIST, MongoSinkTopicConfig.FieldProjectionType.ALLOWLIST}));
            }
        }
    }
}

