/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Evolving;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.LowerBoundSearchCount;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.TotalSearchCount;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.conversions.Bson;

@Evolving
@Beta(value={Beta.Reason.CLIENT, Beta.Reason.SERVER})
public interface SearchCount
extends Bson {
    public static TotalSearchCount total() {
        return new SearchConstructibleBson(new BsonDocument("type", new BsonString("total")));
    }

    public static LowerBoundSearchCount lowerBound() {
        return new SearchConstructibleBson(new BsonDocument("type", new BsonString("lowerBound")));
    }

    public static SearchCount of(Bson count) {
        return new SearchConstructibleBson(Assertions.notNull("count", count));
    }
}

