/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbIncrementalSnapshotChangeEventSource;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.connector.mongodb.MongoDbSnapshotChangeEventSource;
import io.debezium.connector.mongodb.MongoDbStreamingChangeEventSource;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.util.Optional;

public class MongoDbChangeEventSourceFactory
implements ChangeEventSourceFactory<MongoDbPartition, MongoDbOffsetContext> {
    private final MongoDbConnectorConfig configuration;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<MongoDbPartition, CollectionId> dispatcher;
    private final Clock clock;
    private final ReplicaSets replicaSets;
    private final MongoDbTaskContext taskContext;
    private final MongoDbSchema schema;

    public MongoDbChangeEventSourceFactory(MongoDbConnectorConfig configuration, ErrorHandler errorHandler, EventDispatcher<MongoDbPartition, CollectionId> dispatcher, Clock clock, ReplicaSets replicaSets, MongoDbTaskContext taskContext, MongoDbSchema schema) {
        this.configuration = configuration;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.replicaSets = replicaSets;
        this.taskContext = taskContext;
        this.schema = schema;
    }

    @Override
    public SnapshotChangeEventSource<MongoDbPartition, MongoDbOffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener<MongoDbPartition> snapshotProgressListener) {
        return new MongoDbSnapshotChangeEventSource(this.configuration, this.taskContext, this.replicaSets, this.dispatcher, this.clock, snapshotProgressListener, this.errorHandler);
    }

    @Override
    public StreamingChangeEventSource<MongoDbPartition, MongoDbOffsetContext> getStreamingChangeEventSource() {
        return new MongoDbStreamingChangeEventSource(this.configuration, this.taskContext, this.replicaSets, this.dispatcher, this.errorHandler, this.clock);
    }

    @Override
    public Optional<IncrementalSnapshotChangeEventSource<MongoDbPartition, ? extends DataCollectionId>> getIncrementalSnapshotChangeEventSource(MongoDbOffsetContext offsetContext, SnapshotProgressListener<MongoDbPartition> snapshotProgressListener, DataChangeEventListener<MongoDbPartition> dataChangeEventListener) {
        MongoDbIncrementalSnapshotChangeEventSource incrementalSnapshotChangeEventSource = new MongoDbIncrementalSnapshotChangeEventSource(this.configuration, this.taskContext, this.replicaSets, this.dispatcher, this.schema, this.clock, snapshotProgressListener, dataChangeEventListener);
        return Optional.of(incrementalSnapshotChangeEventSource);
    }
}

