/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.jmx.internal;

import com.mongodb.kafka.connect.util.jmx.internal.MBeanServerUtils;
import com.mongodb.kafka.connect.util.jmx.internal.MetricValue;
import com.mongodb.kafka.connect.util.jmx.internal.MongoMBean;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public class CombinedMongoMBean
implements DynamicMBean {
    private String mBeanName;
    private final MongoMBean a;
    private final Map<String, MetricValue> metricsMap = new LinkedHashMap<String, MetricValue>();

    public <T extends MongoMBean> CombinedMongoMBean(String mBeanName, T a, T b) {
        this.mBeanName = mBeanName;
        this.a = a;
        HashMap metricsMap1 = new HashMap();
        a.emit(value1 -> metricsMap1.put(value1.getName(), value1));
        b.emit(value2 -> {
            MetricValue value1 = (MetricValue)metricsMap1.get(value2.getName());
            this.metricsMap.put(value2.getName(), value2.combine(value1));
        });
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.metricsMap.containsKey(attribute)) {
            return new Attribute(attribute, this.metricsMap.get(attribute).get());
        }
        throw new AttributeNotFoundException("getAttribute failed: value not found for: " + attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String name : attributes) {
            if (!this.metricsMap.containsKey(name)) continue;
            list.add(new Attribute(name, this.metricsMap.get(name).get()));
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.a.getMBeanInfo();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException();
    }

    public void register() {
        this.mBeanName = MBeanServerUtils.registerMBean(this, this.mBeanName);
    }

    public void unregister() {
        MBeanServerUtils.unregisterMBean(this.mBeanName);
    }

    public String getName() {
        return this.mBeanName;
    }
}

