/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.compatible.debezium.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.json.DecimalFormat;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.common.utils.ReflectionUtils;

public class DebeziumJsonConverter
implements Serializable {
    private static final String INCLUDE_SCHEMA_METHOD = "convertToJsonWithEnvelope";
    private static final String EXCLUDE_SCHEMA_METHOD = "convertToJsonWithoutEnvelope";
    private final boolean keySchemaEnable;
    private final boolean valueSchemaEnable;
    private volatile transient JsonConverter keyConverter;
    private volatile transient JsonConverter valueConverter;
    private transient Method keyConverterMethod;
    private transient Method valueConverterMethod;

    public String serializeKey(SourceRecord record) throws InvocationTargetException, IllegalAccessException {
        this.tryInit();
        JsonNode jsonNode = (JsonNode)this.keyConverterMethod.invoke((Object)this.keyConverter, record.keySchema(), record.key());
        if (Objects.isNull(jsonNode)) {
            return null;
        }
        return jsonNode.toString();
    }

    public String serializeValue(SourceRecord record) throws InvocationTargetException, IllegalAccessException {
        this.tryInit();
        JsonNode jsonNode = (JsonNode)this.valueConverterMethod.invoke((Object)this.valueConverter, record.valueSchema(), record.value());
        return jsonNode.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryInit() {
        HashMap<String, Object> configs;
        DebeziumJsonConverter debeziumJsonConverter;
        if (this.keyConverter == null) {
            debeziumJsonConverter = this;
            synchronized (debeziumJsonConverter) {
                if (this.keyConverter == null) {
                    this.keyConverter = new JsonConverter();
                    configs = new HashMap<String, Object>();
                    configs.put("schemas.enable", this.keySchemaEnable);
                    configs.put("decimal.format", DecimalFormat.NUMERIC.name());
                    this.keyConverter.configure(configs, true);
                    this.keyConverterMethod = (Method)ReflectionUtils.getDeclaredMethod(JsonConverter.class, (String)(this.keySchemaEnable ? INCLUDE_SCHEMA_METHOD : EXCLUDE_SCHEMA_METHOD), (Class[])new Class[]{Schema.class, Object.class}).get();
                }
            }
        }
        if (this.valueConverter == null) {
            debeziumJsonConverter = this;
            synchronized (debeziumJsonConverter) {
                if (this.valueConverter == null) {
                    this.valueConverter = new JsonConverter();
                    configs = new HashMap();
                    configs.put("schemas.enable", this.valueSchemaEnable);
                    configs.put("decimal.format", DecimalFormat.NUMERIC.name());
                    this.valueConverter.configure(configs, false);
                    this.valueConverterMethod = (Method)ReflectionUtils.getDeclaredMethod(JsonConverter.class, (String)(this.valueSchemaEnable ? INCLUDE_SCHEMA_METHOD : EXCLUDE_SCHEMA_METHOD), (Class[])new Class[]{Schema.class, Object.class}).get();
                }
            }
        }
    }

    public DebeziumJsonConverter(boolean keySchemaEnable, boolean valueSchemaEnable) {
        this.keySchemaEnable = keySchemaEnable;
        this.valueSchemaEnable = valueSchemaEnable;
    }
}

