/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.config;

import java.io.Serializable;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;

public final class StartupConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StartupMode startupMode;
    private final String specificOffsetFile;
    private final Long specificOffsetPos;
    private final Long timestamp;

    public Offset getStartupOffset(OffsetFactory offsetFactory) {
        switch (this.startupMode) {
            case EARLIEST: {
                return offsetFactory.earliest();
            }
            case LATEST: {
                return offsetFactory.latest();
            }
            case INITIAL: {
                return null;
            }
            case SPECIFIC: {
                return offsetFactory.specific(this.specificOffsetFile, this.specificOffsetPos);
            }
            case TIMESTAMP: {
                return offsetFactory.timestamp(this.timestamp);
            }
        }
        throw new IllegalArgumentException(String.format("The %s mode is not supported.", new Object[]{this.startupMode}));
    }

    public StartupConfig(StartupMode startupMode, String specificOffsetFile, Long specificOffsetPos, Long timestamp) {
        this.startupMode = startupMode;
        this.specificOffsetFile = specificOffsetFile;
        this.specificOffsetPos = specificOffsetPos;
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartupConfig)) {
            return false;
        }
        StartupConfig other = (StartupConfig)o;
        Long this$specificOffsetPos = this.specificOffsetPos;
        Long other$specificOffsetPos = other.specificOffsetPos;
        if (this$specificOffsetPos == null ? other$specificOffsetPos != null : !((Object)this$specificOffsetPos).equals(other$specificOffsetPos)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        StartupMode this$startupMode = this.getStartupMode();
        StartupMode other$startupMode = other.getStartupMode();
        if (this$startupMode == null ? other$startupMode != null : !((Object)((Object)this$startupMode)).equals((Object)other$startupMode)) {
            return false;
        }
        String this$specificOffsetFile = this.specificOffsetFile;
        String other$specificOffsetFile = other.specificOffsetFile;
        return !(this$specificOffsetFile == null ? other$specificOffsetFile != null : !this$specificOffsetFile.equals(other$specificOffsetFile));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $specificOffsetPos = this.specificOffsetPos;
        result = result * 59 + ($specificOffsetPos == null ? 43 : ((Object)$specificOffsetPos).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        StartupMode $startupMode = this.getStartupMode();
        result = result * 59 + ($startupMode == null ? 43 : ((Object)((Object)$startupMode)).hashCode());
        String $specificOffsetFile = this.specificOffsetFile;
        result = result * 59 + ($specificOffsetFile == null ? 43 : $specificOffsetFile.hashCode());
        return result;
    }

    public StartupMode getStartupMode() {
        return this.startupMode;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }
}

