/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.dialect;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.dialect.DataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.relational.connection.JdbcConnectionPoolFactory;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.FetchTask;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.JdbcSourceFetchTaskContext;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;

public interface JdbcDataSourceDialect
extends DataSourceDialect<JdbcSourceConfig> {
    @Override
    public List<TableId> discoverDataCollections(JdbcSourceConfig var1);

    default public void checkAllTablesEnabledCapture(JdbcConnection jdbcConnection, List<TableId> tableIds) throws SQLException {
    }

    public JdbcConnection openJdbcConnection(JdbcSourceConfig var1);

    default public JdbcConnectionPoolFactory getPooledDataSourceFactory() {
        throw new UnsupportedOperationException();
    }

    public TableChanges.TableChange queryTableSchema(JdbcConnection var1, TableId var2);

    @Override
    public FetchTask<SourceSplitBase> createFetchTask(SourceSplitBase var1);

    public JdbcSourceFetchTaskContext createFetchTaskContext(SourceSplitBase var1, JdbcSourceConfig var2);

    default public Optional<PrimaryKey> getPrimaryKey(JdbcConnection jdbcConnection, TableId tableId) throws SQLException {
        DatabaseMetaData metaData = jdbcConnection.connection().getMetaData();
        ArrayList<Pair> primaryKeyColumns = new ArrayList<Pair>();
        String pkName = null;
        try (ResultSet rs = metaData.getPrimaryKeys(tableId.catalog(), tableId.schema(), tableId.table());){
            while (rs.next()) {
                pkName = rs.getString("PK_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                int keySeq = rs.getInt("KEY_SEQ");
                primaryKeyColumns.add(Pair.of((Object)keySeq, (Object)columnName));
            }
        }
        List pkFields = primaryKeyColumns.stream().sorted(Comparator.comparingInt(Pair::getKey)).map(Pair::getValue).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pkFields)) {
            return Optional.empty();
        }
        return Optional.of(PrimaryKey.of((String)pkName, pkFields));
    }

    default public List<ConstraintKey> getUniqueKeys(JdbcConnection jdbcConnection, TableId tableId) throws SQLException {
        return this.getConstraintKeys(jdbcConnection, tableId).stream().filter(constraintKey -> constraintKey.getConstraintType() == ConstraintKey.ConstraintType.UNIQUE_KEY).collect(Collectors.toList());
    }

    default public List<ConstraintKey> getConstraintKeys(JdbcConnection jdbcConnection, TableId tableId) throws SQLException {
        DatabaseMetaData metaData = jdbcConnection.connection().getMetaData();
        try (ResultSet resultSet = metaData.getIndexInfo(tableId.catalog(), tableId.schema(), tableId.table(), false, false);){
            HashMap<String, ConstraintKey> constraintKeyMap = new HashMap<String, ConstraintKey>();
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                if (columnName == null) continue;
                String indexName = resultSet.getString("INDEX_NAME");
                boolean noUnique = resultSet.getBoolean("NON_UNIQUE");
                ConstraintKey constraintKey = constraintKeyMap.computeIfAbsent(indexName, s -> {
                    ConstraintKey.ConstraintType constraintType = ConstraintKey.ConstraintType.INDEX_KEY;
                    if (!noUnique) {
                        constraintType = ConstraintKey.ConstraintType.UNIQUE_KEY;
                    }
                    return ConstraintKey.of((ConstraintKey.ConstraintType)constraintType, (String)indexName, new ArrayList());
                });
                ConstraintKey.ColumnSortType sortType = "A".equals(resultSet.getString("ASC_OR_DESC")) ? ConstraintKey.ColumnSortType.ASC : ConstraintKey.ColumnSortType.DESC;
                ConstraintKey.ConstraintKeyColumn constraintKeyColumn = new ConstraintKey.ConstraintKeyColumn(columnName, sortType);
                constraintKey.getColumnNames().add(constraintKeyColumn);
            }
            ArrayList<ConstraintKey> arrayList = new ArrayList<ConstraintKey>(constraintKeyMap.values());
            return arrayList;
        }
    }
}

