/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.relational.connection;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;

public abstract class JdbcConnectionPoolFactory {
    public static final String CONNECTION_POOL_PREFIX = "connection-pool-";
    public static final String SERVER_TIMEZONE_KEY = "serverTimezone";
    public static final int MINIMUM_POOL_SIZE = 1;

    public HikariDataSource createPooledDataSource(JdbcSourceConfig sourceConfig) {
        HikariConfig config = new HikariConfig();
        String hostName = sourceConfig.getHostname();
        int port = sourceConfig.getPort();
        config.setPoolName(CONNECTION_POOL_PREFIX + hostName + ":" + port);
        config.setJdbcUrl(sourceConfig.getOriginUrl());
        config.setUsername(sourceConfig.getUsername());
        config.setPassword(sourceConfig.getPassword());
        config.setDriverClassName(sourceConfig.getDriverClassName());
        config.setMinimumIdle(1);
        config.setMaximumPoolSize(sourceConfig.getConnectionPoolSize());
        config.setConnectionTimeout(sourceConfig.getConnectTimeoutMillis());
        config.addDataSourceProperty(SERVER_TIMEZONE_KEY, (Object)sourceConfig.getServerTimeZone());
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        return new HikariDataSource(config);
    }

    public abstract String getJdbcUrl(JdbcSourceConfig var1);
}

