/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.heartbeat;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.heartbeat.DatabaseHeartbeatImpl;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.heartbeat.HeartbeatConnectionProvider;
import io.debezium.heartbeat.HeartbeatErrorHandler;
import io.debezium.heartbeat.HeartbeatImpl;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import io.debezium.util.Strings;
import java.time.Duration;

public class HeartbeatFactory<T extends DataCollectionId> {
    private final CommonConnectorConfig connectorConfig;
    private final TopicSelector<T> topicSelector;
    private final SchemaNameAdjuster schemaNameAdjuster;
    private final HeartbeatConnectionProvider connectionProvider;
    private final HeartbeatErrorHandler errorHandler;

    public HeartbeatFactory(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, SchemaNameAdjuster schemaNameAdjuster) {
        this(connectorConfig, topicSelector, schemaNameAdjuster, null, null);
    }

    public HeartbeatFactory(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, SchemaNameAdjuster schemaNameAdjuster, HeartbeatConnectionProvider connectionProvider, HeartbeatErrorHandler errorHandler) {
        this.connectorConfig = connectorConfig;
        this.topicSelector = topicSelector;
        this.schemaNameAdjuster = schemaNameAdjuster;
        this.connectionProvider = connectionProvider;
        this.errorHandler = errorHandler;
    }

    public Heartbeat createHeartbeat() {
        RelationalDatabaseConnectorConfig relConfig;
        Duration heartbeatInterval = this.connectorConfig.getHeartbeatInterval();
        if (heartbeatInterval.isZero()) {
            heartbeatInterval = Duration.ofMillis(5000L);
        }
        if (this.connectorConfig instanceof RelationalDatabaseConnectorConfig && !Strings.isNullOrBlank((String)(relConfig = (RelationalDatabaseConnectorConfig)this.connectorConfig).getHeartbeatActionQuery())) {
            return new DatabaseHeartbeatImpl(heartbeatInterval, this.topicSelector.getHeartbeatTopic(), this.connectorConfig.getLogicalName(), this.connectionProvider.get(), relConfig.getHeartbeatActionQuery(), this.errorHandler, this.schemaNameAdjuster);
        }
        return new HeartbeatImpl(heartbeatInterval, this.topicSelector.getHeartbeatTopic(), this.connectorConfig.getLogicalName(), this.schemaNameAdjuster);
    }
}

