/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.maxwell;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.format.json.exception.SeaTunnelJsonFormatException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;

public class MaxWellJsonDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_OLD = "old";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_TYPE = "type";
    private static final String OP_INSERT = "insert";
    private static final String OP_UPDATE = "update";
    private static final String OP_DELETE = "delete";
    private static final String FIELD_DATABASE = "database";
    private static final String FIELD_TABLE = "table";
    private final String database;
    private final String table;
    private final String[] fieldNames;
    private final int fieldCount;
    private final boolean ignoreParseErrors;
    private final Pattern databasePattern;
    private final Pattern tablePattern;
    private final JsonDeserializationSchema jsonDeserializer;
    private final CatalogTable catalogTable;
    private final SeaTunnelRowType seaTunnelRowType;

    public MaxWellJsonDeserializationSchema(CatalogTable catalogTable, String database, String table, boolean ignoreParseErrors) {
        this.catalogTable = catalogTable;
        this.seaTunnelRowType = catalogTable.getSeaTunnelRowType();
        this.jsonDeserializer = new JsonDeserializationSchema(false, ignoreParseErrors, this.seaTunnelRowType);
        this.database = database;
        this.table = table;
        this.fieldNames = this.seaTunnelRowType.getFieldNames();
        this.fieldCount = this.seaTunnelRowType.getTotalFields();
        this.ignoreParseErrors = ignoreParseErrors;
        this.databasePattern = database == null ? null : Pattern.compile(database);
        this.tablePattern = table == null ? null : Pattern.compile(table);
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedOperationException();
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.seaTunnelRowType;
    }

    public void deserialize(byte[] message, Collector<SeaTunnelRow> out) {
        if (message == null) {
            return;
        }
        ObjectNode jsonNode = (ObjectNode)this.convertBytes(message);
        if (this.database != null && !this.databasePattern.matcher(jsonNode.get(FIELD_DATABASE).asText()).matches()) {
            return;
        }
        if (this.table != null && !this.tablePattern.matcher(jsonNode.get(FIELD_TABLE).asText()).matches()) {
            return;
        }
        JsonNode dataNode = jsonNode.get(FIELD_DATA);
        String type = jsonNode.get(FIELD_TYPE).asText();
        if (OP_INSERT.equals(type)) {
            SeaTunnelRow rowInsert = this.convertJsonNode(dataNode);
            rowInsert.setRowKind(RowKind.INSERT);
            out.collect((Object)rowInsert);
        } else if (OP_UPDATE.equals(type)) {
            SeaTunnelRow rowAfter = this.convertJsonNode(dataNode);
            JsonNode oldNode = jsonNode.get(FIELD_OLD);
            SeaTunnelRow rowBefore = this.convertJsonNode(oldNode);
            for (int f = 0; f < this.fieldCount; ++f) {
                assert (rowBefore != null);
                if (!rowBefore.isNullAt(f) || oldNode.findValue(this.fieldNames[f]) != null) continue;
                assert (rowAfter != null);
                rowBefore.setField(f, rowAfter.getField(f));
            }
            assert (rowBefore != null);
            rowBefore.setRowKind(RowKind.UPDATE_BEFORE);
            assert (rowAfter != null);
            rowAfter.setRowKind(RowKind.UPDATE_AFTER);
            out.collect((Object)rowBefore);
            out.collect((Object)rowAfter);
        } else if (OP_DELETE.equals(type)) {
            SeaTunnelRow rowDelete = this.convertJsonNode(dataNode);
            rowDelete.setRowKind(RowKind.DELETE);
            out.collect((Object)rowDelete);
        } else if (!this.ignoreParseErrors) {
            throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("Unknown \"type\" value \"%s\". The MaxWell JSON message is '%s'", type, new String(message)));
        }
    }

    private JsonNode convertBytes(byte[] message) {
        try {
            return this.jsonDeserializer.deserializeToJsonNode(message);
        }
        catch (Exception t) {
            if (this.ignoreParseErrors) {
                return null;
            }
            throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_CONNECTOR_TYPE_ERROR_SIMPLE, String.format("Failed to deserialize JSON '%s'.", new String(message)), t);
        }
    }

    private SeaTunnelRow convertJsonNode(JsonNode root) {
        return this.jsonDeserializer.convertToRowData(root);
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType physicalDataType) {
        return physicalDataType;
    }

    public static Builder builder(CatalogTable catalogTable) {
        return new Builder(catalogTable);
    }

    public static class Builder {
        private boolean ignoreParseErrors = false;
        private String database = null;
        private String table = null;
        private final CatalogTable catalogTable;

        public Builder(CatalogTable catalogTable) {
            this.catalogTable = catalogTable;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public MaxWellJsonDeserializationSchema build() {
            return new MaxWellJsonDeserializationSchema(this.catalogTable, this.database, this.table, this.ignoreParseErrors);
        }
    }
}

