/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import org.apache.rya.periodic.notification.notification.PeriodicNotification;

public class PeriodicNotificationTypeAdapter
implements JsonSerializer<PeriodicNotification>,
JsonDeserializer<PeriodicNotification> {
    public PeriodicNotification deserialize(JsonElement arg0, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
        JsonObject json = arg0.getAsJsonObject();
        String id = json.get("id").getAsString();
        long period = json.get("period").getAsLong();
        TimeUnit periodTimeUnit = TimeUnit.valueOf(json.get("timeUnit").getAsString());
        long initialDelay = json.get("initialDelay").getAsLong();
        PeriodicNotification.Builder builder = PeriodicNotification.builder().id(id).period(period).initialDelay(initialDelay).timeUnit(periodTimeUnit);
        return builder.build();
    }

    public JsonElement serialize(PeriodicNotification arg0, Type arg1, JsonSerializationContext arg2) {
        JsonObject result = new JsonObject();
        result.add("id", (JsonElement)new JsonPrimitive(arg0.getId()));
        result.add("period", (JsonElement)new JsonPrimitive((Number)arg0.getPeriod()));
        result.add("initialDelay", (JsonElement)new JsonPrimitive((Number)arg0.getInitialDelay()));
        result.add("timeUnit", (JsonElement)new JsonPrimitive(arg0.getTimeUnit().name()));
        return result;
    }
}

