/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.rya.periodic.notification.api.Notification;
import org.apache.rya.periodic.notification.notification.BasicNotification;
import org.apache.rya.periodic.notification.notification.CommandNotification;
import org.apache.rya.periodic.notification.notification.PeriodicNotification;
import org.apache.rya.periodic.notification.serialization.BasicNotificationTypeAdapter;
import org.apache.rya.periodic.notification.serialization.PeriodicNotificationTypeAdapter;

public class CommandNotificationTypeAdapter
implements JsonDeserializer<CommandNotification>,
JsonSerializer<CommandNotification> {
    public JsonElement serialize(CommandNotification arg0, Type arg1, JsonSerializationContext arg2) {
        JsonObject result = new JsonObject();
        result.add("command", (JsonElement)new JsonPrimitive(arg0.getCommand().name()));
        Notification notification = arg0.getNotification();
        if (notification instanceof PeriodicNotification) {
            result.add("type", (JsonElement)new JsonPrimitive(PeriodicNotification.class.getSimpleName()));
            PeriodicNotificationTypeAdapter adapter = new PeriodicNotificationTypeAdapter();
            result.add("notification", adapter.serialize((PeriodicNotification)notification, (Type)((Object)PeriodicNotification.class), arg2));
        } else if (notification instanceof BasicNotification) {
            result.add("type", (JsonElement)new JsonPrimitive(BasicNotification.class.getSimpleName()));
            BasicNotificationTypeAdapter adapter = new BasicNotificationTypeAdapter();
            result.add("notification", adapter.serialize((BasicNotification)notification, (Type)((Object)BasicNotification.class), arg2));
        } else {
            throw new IllegalArgumentException("Invalid notification type.");
        }
        return result;
    }

    public CommandNotification deserialize(JsonElement arg0, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
        JsonObject json = arg0.getAsJsonObject();
        CommandNotification.Command command = CommandNotification.Command.valueOf(json.get("command").getAsString());
        String type = json.get("type").getAsString();
        Notification notification = null;
        if (type.equals(PeriodicNotification.class.getSimpleName())) {
            notification = new PeriodicNotificationTypeAdapter().deserialize(json.get("notification"), (Type)((Object)PeriodicNotification.class), arg2);
        } else if (type.equals(BasicNotification.class.getSimpleName())) {
            notification = new BasicNotificationTypeAdapter().deserialize(json.get("notification"), (Type)((Object)BasicNotification.class), arg2);
        } else {
            throw new JsonParseException("Cannot deserialize Json");
        }
        return new CommandNotification(command, notification);
    }
}

