/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.rya.periodic.notification.api.Notification;
import org.apache.rya.periodic.notification.notification.CommandNotification;
import org.apache.rya.periodic.notification.serialization.CommandNotificationTypeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandNotificationSerializer
implements Serializer<CommandNotification>,
Deserializer<CommandNotification> {
    private static Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Notification.class, (Object)new CommandNotificationTypeAdapter()).create();
    private static final Logger LOG = LoggerFactory.getLogger(CommandNotificationSerializer.class);

    public CommandNotification deserialize(String topic, byte[] bytes) {
        try {
            String json = new String(bytes, StandardCharsets.UTF_8);
            return (CommandNotification)gson.fromJson(json, CommandNotification.class);
        }
        catch (JsonParseException e) {
            LOG.warn("Unable to deserialize notification for topic: " + topic);
            throw new RuntimeException(e);
        }
    }

    public byte[] serialize(String topic, CommandNotification command) {
        try {
            return gson.toJson((Object)command).getBytes(StandardCharsets.UTF_8);
        }
        catch (JsonParseException e) {
            LOG.warn("Unable to serialize notification: " + command + "for topic: " + topic);
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }

    public void configure(Map<String, ?> arg0, boolean arg1) {
    }
}

