/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.serialization;

import com.google.common.base.Joiner;
import com.google.common.primitives.Bytes;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjSerializer;
import org.apache.rya.indexing.pcj.storage.accumulo.BindingSetConverter;
import org.apache.rya.indexing.pcj.storage.accumulo.VariableOrder;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingSetSerDe
implements Serializer<BindingSet>,
Deserializer<BindingSet> {
    private static final Logger log = LoggerFactory.getLogger(BindingSetSerDe.class);
    private static final AccumuloPcjSerializer serializer = new AccumuloPcjSerializer();
    private static final byte[] DELIM_BYTE = "\u0002".getBytes(StandardCharsets.UTF_8);

    private byte[] toBytes(BindingSet bindingSet) {
        try {
            return this.getBytes(this.getVarOrder(bindingSet), bindingSet);
        }
        catch (Exception e) {
            log.trace("Unable to serialize BindingSet: " + bindingSet);
            return new byte[0];
        }
    }

    private BindingSet fromBytes(byte[] bsBytes) {
        try {
            int firstIndex = Bytes.indexOf((byte[])bsBytes, (byte[])DELIM_BYTE);
            byte[] varOrderBytes = Arrays.copyOf(bsBytes, firstIndex);
            byte[] bsBytesNoVarOrder = Arrays.copyOfRange(bsBytes, firstIndex + 1, bsBytes.length);
            VariableOrder varOrder = new VariableOrder(new String(varOrderBytes, StandardCharsets.UTF_8).split(";"));
            return this.getBindingSet(varOrder, bsBytesNoVarOrder);
        }
        catch (Exception e) {
            log.trace("Unable to deserialize BindingSet: " + bsBytes);
            return new QueryBindingSet();
        }
    }

    private VariableOrder getVarOrder(BindingSet bs) {
        return new VariableOrder((Collection)bs.getBindingNames());
    }

    private byte[] getBytes(VariableOrder varOrder, BindingSet bs) throws UnsupportedEncodingException, BindingSetConverter.BindingSetConversionException {
        byte[] bsBytes = serializer.convert(bs, varOrder);
        String varOrderString = Joiner.on((String)";").join((Iterable)varOrder.getVariableOrders());
        byte[] varOrderBytes = varOrderString.getBytes(StandardCharsets.UTF_8);
        return Bytes.concat((byte[][])new byte[][]{varOrderBytes, DELIM_BYTE, bsBytes});
    }

    private BindingSet getBindingSet(VariableOrder varOrder, byte[] bsBytes) throws BindingSetConverter.BindingSetConversionException {
        return serializer.convert(bsBytes, varOrder);
    }

    public BindingSet deserialize(String topic, byte[] bytes) {
        return this.fromBytes(bytes);
    }

    public void close() {
    }

    public void configure(Map<String, ?> arg0, boolean arg1) {
    }

    public byte[] serialize(String topic, BindingSet bs) {
        return this.toBytes(bs);
    }
}

