/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.registration;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.rya.periodic.notification.api.PeriodicNotificationClient;
import org.apache.rya.periodic.notification.notification.BasicNotification;
import org.apache.rya.periodic.notification.notification.CommandNotification;
import org.apache.rya.periodic.notification.notification.PeriodicNotification;

public class KafkaNotificationRegistrationClient
implements PeriodicNotificationClient {
    private final KafkaProducer<String, CommandNotification> producer;
    private final String topic;

    public KafkaNotificationRegistrationClient(String topic, KafkaProducer<String, CommandNotification> producer) {
        this.topic = topic;
        this.producer = producer;
    }

    @Override
    public void addNotification(PeriodicNotification notification) {
        this.processNotification(new CommandNotification(CommandNotification.Command.ADD, notification));
    }

    @Override
    public void deleteNotification(BasicNotification notification) {
        this.processNotification(new CommandNotification(CommandNotification.Command.DELETE, notification));
    }

    @Override
    public void deleteNotification(String notificationId) {
        this.processNotification(new CommandNotification(CommandNotification.Command.DELETE, new BasicNotification(notificationId)));
    }

    @Override
    public void addNotification(String id, long period, long delay, TimeUnit unit) {
        PeriodicNotification notification = PeriodicNotification.builder().id(id).period(period).initialDelay(delay).timeUnit(unit).build();
        this.processNotification(new CommandNotification(CommandNotification.Command.ADD, notification));
    }

    private void processNotification(CommandNotification notification) {
        this.producer.send(new ProducerRecord(this.topic, (Object)notification.getId(), (Object)notification));
    }

    @Override
    public void close() {
        this.producer.close();
    }
}

