/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.notification;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.rya.periodic.notification.api.Notification;

public class PeriodicNotification
implements Notification {
    private String id;
    private long period;
    private TimeUnit periodTimeUnit;
    private long initialDelay;

    public PeriodicNotification(String id, long period, TimeUnit periodTimeUnit, long initialDelay) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.periodTimeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)periodTimeUnit)));
        Preconditions.checkArgument((period > 0L && initialDelay >= 0L ? 1 : 0) != 0);
        this.period = period;
        this.initialDelay = initialDelay;
    }

    public PeriodicNotification(PeriodicNotification other) {
        this(other.id, other.period, other.periodTimeUnit, other.initialDelay);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public long getPeriod() {
        return this.period;
    }

    public TimeUnit getTimeUnit() {
        return this.periodTimeUnit;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String delim = "=";
        String delim2 = ";";
        return builder.append("id").append(delim).append(this.id).append(delim2).append("period").append(delim).append(this.period).append(delim2).append("periodTimeUnit").append(delim).append((Object)this.periodTimeUnit).append(delim2).append("initialDelay").append(delim).append(this.initialDelay).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PeriodicNotification)) {
            return false;
        }
        PeriodicNotification notification = (PeriodicNotification)other;
        return Objects.equals(this.id, notification.id) && this.period == notification.period && Objects.equals((Object)this.periodTimeUnit, (Object)notification.periodTimeUnit) && this.initialDelay == notification.initialDelay;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.period, this.periodTimeUnit, this.initialDelay});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private long period;
        private TimeUnit periodTimeUnit;
        private long initialDelay = 0L;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder period(long period) {
            this.period = period;
            return this;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.periodTimeUnit = timeUnit;
            return this;
        }

        public Builder initialDelay(long initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public PeriodicNotification build() {
            return new PeriodicNotification(this.id, this.period, this.periodTimeUnit, this.initialDelay);
        }
    }
}

