/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.fluo.api;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.Snapshot;
import org.apache.fluo.api.client.SnapshotBase;
import org.apache.rya.api.client.CreatePCJ;
import org.apache.rya.indexing.pcj.fluo.api.ListQueryIds;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQueryMetadataDAO;
import org.apache.rya.indexing.pcj.fluo.app.query.QueryMetadata;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLParser;
import org.eclipse.rdf4j.queryrender.sparql.SPARQLQueryRenderer;

public class ListFluoQueries {
    private static final FluoQueryMetadataDAO dao = new FluoQueryMetadataDAO();

    public List<String> listFluoQueries(FluoClient fluo) throws Exception {
        ArrayList<String> queryStrings = new ArrayList<String>();
        Snapshot sx = fluo.newSnapshot();
        List<String> ids = new ListQueryIds().listQueryIds(fluo);
        for (String id : ids) {
            queryStrings.add(ListFluoQueries.extractString(dao.readQueryMetadata((SnapshotBase)sx, id)));
        }
        return queryStrings;
    }

    private static String extractString(QueryMetadata metadata) throws Exception {
        FluoQueryStringBuilder builder = new FluoQueryStringBuilder();
        return builder.setQueryId(metadata.getNodeId()).setQueryType(metadata.getQueryType()).setExportStrategies(metadata.getExportStrategies()).setQuery(metadata.getSparql()).build();
    }

    private static String getPrettyPrintSparql(String sparql, int indent) throws Exception {
        SPARQLParser parser = new SPARQLParser();
        ParsedQuery pq = parser.parseQuery(sparql, null);
        SPARQLQueryRenderer render = new SPARQLQueryRenderer();
        String renderedQuery = render.render(pq);
        String[] splitRender = renderedQuery.split("\"\"\"");
        StringBuilder builder = new StringBuilder();
        for (String s : splitRender) {
            builder.append(s).append("\"");
        }
        builder.replace(builder.length() - 1, builder.length(), "");
        String[] newLineRender = builder.toString().split("\n");
        builder = new StringBuilder();
        String prefix = ListFluoQueries.getVariableIndent(indent);
        for (int i = 0; i < newLineRender.length; ++i) {
            if (i != 0) {
                builder.append(prefix);
            }
            builder.append(newLineRender[i]).append("\n");
        }
        return builder.toString();
    }

    private static String getVariableIndent(int len) {
        return new String(new char[len]).replace('\u0000', ' ');
    }

    public static class FluoQueryStringBuilder {
        private String queryId;
        private String sparql;
        private CreatePCJ.QueryType queryType;
        private Set<CreatePCJ.ExportStrategy> strategies;

        public FluoQueryStringBuilder setQueryId(String queryId) {
            this.queryId = (String)Preconditions.checkNotNull((Object)queryId);
            return this;
        }

        public FluoQueryStringBuilder setQuery(String query) {
            this.sparql = (String)Preconditions.checkNotNull((Object)query);
            return this;
        }

        public FluoQueryStringBuilder setExportStrategies(Set<CreatePCJ.ExportStrategy> strategies) {
            this.strategies = (Set)Preconditions.checkNotNull(strategies);
            return this;
        }

        public FluoQueryStringBuilder setQueryType(CreatePCJ.QueryType queryType) {
            this.queryType = (CreatePCJ.QueryType)Preconditions.checkNotNull((Object)queryType);
            return this;
        }

        public String build() throws Exception {
            int valueAlign = 20;
            String sparqlHeader = "SPARQL: ";
            String idHeader = "QUERY ID: ";
            String typeHeader = "QUERY TYPE: ";
            String strategiesHeader = "EXPORT STRATEGIES: ";
            StringBuilder builder = new StringBuilder();
            builder.append(idHeader).append(ListFluoQueries.getVariableIndent(valueAlign - idHeader.length())).append(this.queryId).append("\n").append(typeHeader).append(ListFluoQueries.getVariableIndent(valueAlign - typeHeader.length())).append(this.queryType).append("\n").append(strategiesHeader).append(ListFluoQueries.getVariableIndent(valueAlign - strategiesHeader.length())).append(this.strategies).append("\n").append(sparqlHeader).append(ListFluoQueries.getVariableIndent(valueAlign - sparqlHeader.length())).append(ListFluoQueries.getPrettyPrintSparql(this.sparql, valueAlign)).append("\n");
            return builder.toString();
        }
    }
}

