/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.fluo.api;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.Transaction;
import org.apache.fluo.api.data.Bytes;
import org.apache.log4j.Logger;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.api.resolver.triple.TripleRowResolverException;
import org.apache.rya.api.resolver.triple.impl.WholeRowTripleResolver;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQueryColumns;
import org.apache.rya.indexing.pcj.fluo.app.util.TriplePrefixUtils;

public class InsertTriples {
    private static final Logger log = Logger.getLogger(InsertTriples.class);
    private static final WholeRowTripleResolver TRIPLE_RESOLVER = new WholeRowTripleResolver();

    public void insert(FluoClient fluo, RyaStatement triple, Optional<String> visibility) {
        this.insert(fluo, Collections.singleton(triple), visibility);
    }

    public void insert(FluoClient fluo, Collection<RyaStatement> triples, Optional<String> visibility) {
        Preconditions.checkNotNull((Object)fluo);
        Preconditions.checkNotNull(triples);
        Preconditions.checkNotNull(visibility);
        try (Transaction tx = fluo.newTransaction();){
            for (RyaStatement triple : triples) {
                try {
                    tx.set(InsertTriples.spoFormat(triple), FluoQueryColumns.TRIPLES, Bytes.of((String)((String)visibility.or((Object)""))));
                }
                catch (TripleRowResolverException e) {
                    log.error((Object)("Could not convert a Triple into the SPO format: " + triple));
                }
            }
            tx.commit();
        }
    }

    public void insert(FluoClient fluo, RyaStatement triple) {
        Preconditions.checkNotNull((Object)fluo);
        Preconditions.checkNotNull((Object)triple);
        this.insert(fluo, Collections.singleton(triple));
    }

    public void insert(FluoClient fluo, Collection<RyaStatement> triples) {
        Preconditions.checkNotNull((Object)fluo);
        Preconditions.checkNotNull(triples);
        try (Transaction tx = fluo.newTransaction();){
            for (RyaStatement triple : triples) {
                Optional visibility = Optional.fromNullable((Object)triple.getColumnVisibility());
                try {
                    tx.set(InsertTriples.spoFormat(triple), FluoQueryColumns.TRIPLES, Bytes.of((byte[])((byte[])visibility.or((Object)new byte[0]))));
                }
                catch (TripleRowResolverException e) {
                    log.error((Object)("Could not convert a Triple into the SPO format: " + triple));
                }
            }
            tx.commit();
        }
    }

    public static Bytes spoFormat(RyaStatement triple) throws TripleRowResolverException {
        Preconditions.checkNotNull((Object)triple);
        Map serialized = TRIPLE_RESOLVER.serialize(triple);
        TripleRow spoRow = (TripleRow)serialized.get(RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO);
        return TriplePrefixUtils.addTriplePrefixAndConvertToBytes((byte[])spoRow.getRow());
    }
}

