/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.fluo.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.Snapshot;
import org.apache.fluo.api.client.SnapshotBase;
import org.apache.fluo.api.client.scanner.ColumnScanner;
import org.apache.fluo.api.client.scanner.RowScanner;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.Span;
import org.apache.rya.indexing.pcj.fluo.api.ListQueryIds;
import org.apache.rya.indexing.pcj.fluo.app.BindingSetRow;
import org.apache.rya.indexing.pcj.fluo.app.NodeType;
import org.apache.rya.indexing.pcj.fluo.app.query.FilterMetadata;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQuery;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQueryColumns;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQueryMetadataDAO;
import org.apache.rya.indexing.pcj.fluo.app.query.JoinMetadata;
import org.apache.rya.indexing.pcj.fluo.app.query.StatementPatternMetadata;
import org.apache.rya.indexing.pcj.fluo.app.query.UnsupportedQueryException;

@DefaultAnnotation(value={NonNull.class})
public class GetQueryReport {
    private final FluoQueryMetadataDAO metadataDao = new FluoQueryMetadataDAO();

    public Map<String, QueryReport> getAllQueryReports(FluoClient fluo) throws UnsupportedQueryException {
        Preconditions.checkNotNull((Object)fluo);
        List<String> queryIds = new ListQueryIds().listQueryIds(fluo);
        HashMap<String, QueryReport> reports = new HashMap<String, QueryReport>();
        for (String queryId : queryIds) {
            QueryReport report = this.getReport(fluo, queryId);
            reports.put(queryId, report);
        }
        return reports;
    }

    public QueryReport getReport(FluoClient fluo, String queryId) throws UnsupportedQueryException {
        Preconditions.checkNotNull((Object)fluo);
        Preconditions.checkNotNull((Object)queryId);
        QueryReport.Builder reportBuilder = QueryReport.builder();
        try (Snapshot sx = fluo.newSnapshot();){
            FluoQuery fluoQuery = this.metadataDao.readFluoQuery((SnapshotBase)sx, queryId);
            reportBuilder.setFluoQuery(fluoQuery);
            BigInteger count = this.countBindingSets((SnapshotBase)sx, queryId, FluoQueryColumns.QUERY_BINDING_SET);
            reportBuilder.setCount(queryId, count);
            for (FilterMetadata filter : fluoQuery.getFilterMetadata()) {
                String filterId = filter.getNodeId();
                count = this.countBindingSets((SnapshotBase)sx, filterId, FluoQueryColumns.FILTER_BINDING_SET);
                reportBuilder.setCount(filterId, count);
            }
            for (JoinMetadata join : fluoQuery.getJoinMetadata()) {
                String joinId = join.getNodeId();
                count = this.countBindingSets((SnapshotBase)sx, joinId, FluoQueryColumns.JOIN_BINDING_SET);
                reportBuilder.setCount(joinId, count);
            }
            for (StatementPatternMetadata statementPattern : fluoQuery.getStatementPatternMetadata()) {
                String patternId = statementPattern.getNodeId();
                count = this.countBindingSets((SnapshotBase)sx, patternId, FluoQueryColumns.STATEMENT_PATTERN_BINDING_SET);
                reportBuilder.setCount(patternId, count);
            }
        }
        return reportBuilder.build();
    }

    private BigInteger countBindingSets(SnapshotBase sx, String nodeId, Column bindingSetColumn) {
        Preconditions.checkNotNull((Object)sx);
        Preconditions.checkNotNull((Object)nodeId);
        Preconditions.checkNotNull((Object)bindingSetColumn);
        NodeType type = (NodeType)NodeType.fromNodeId((String)nodeId).get();
        Bytes prefixBytes = Bytes.of((String)type.getNodeTypePrefix());
        RowScanner rows = sx.scanner().over(Span.prefix((Bytes)prefixBytes)).fetch(new Column[]{bindingSetColumn}).byRow().build();
        BigInteger count = BigInteger.valueOf(0L);
        for (ColumnScanner columns : rows) {
            String row = BindingSetRow.makeFromShardedRow((Bytes)prefixBytes, (Bytes)columns.getRow()).getNodeId();
            if (!row.equals(nodeId)) continue;
            count = count.add(BigInteger.ONE);
        }
        return count;
    }

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static final class QueryReport {
        private final FluoQuery fluoQuery;
        private final ImmutableMap<String, BigInteger> counts;

        private QueryReport(FluoQuery fluoQuery, ImmutableMap<String, BigInteger> counts) {
            this.fluoQuery = (FluoQuery)Preconditions.checkNotNull((Object)fluoQuery);
            this.counts = (ImmutableMap)Preconditions.checkNotNull(counts);
        }

        public FluoQuery getFluoQuery() {
            return this.fluoQuery;
        }

        public BigInteger getCount(String nodeId) {
            Preconditions.checkNotNull((Object)nodeId);
            return (BigInteger)this.counts.get((Object)nodeId);
        }

        public ImmutableMap<String, BigInteger> getCounts() {
            return this.counts;
        }

        public static Builder builder() {
            return new Builder();
        }

        @DefaultAnnotation(value={NonNull.class})
        public static final class Builder {
            private FluoQuery fluoQuery = null;
            private final ImmutableMap.Builder<String, BigInteger> counts = ImmutableMap.builder();

            public Builder setFluoQuery(@Nullable FluoQuery fluoQuery) {
                this.fluoQuery = fluoQuery;
                return this;
            }

            public Builder setCount(@Nullable String nodeId, @Nullable BigInteger count) {
                this.counts.put((Object)nodeId, (Object)count);
                return this;
            }

            public QueryReport build() {
                return new QueryReport(this.fluoQuery, this.counts.build());
            }
        }
    }
}

