/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.fluo.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.Snapshot;
import org.apache.rya.indexing.pcj.fluo.api.ListQueryIds;
import org.apache.rya.indexing.pcj.fluo.app.util.FluoQueryUtils;
import org.apache.rya.indexing.pcj.storage.PcjException;
import org.apache.rya.indexing.pcj.storage.PcjMetadata;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;

public class GetPcjMetadata {
    private final ListQueryIds listQueryIds = new ListQueryIds();

    public Map<String, PcjMetadata> getMetadata(PrecomputedJoinStorage pcjStorage, FluoClient fluo) throws NotInFluoException, NotInAccumuloException {
        Objects.requireNonNull(pcjStorage);
        Objects.requireNonNull(fluo);
        HashMap<String, PcjMetadata> metadata = new HashMap<String, PcjMetadata>();
        List<String> queryIds = this.listQueryIds.listQueryIds(fluo);
        for (String queryId : queryIds) {
            metadata.put(queryId, this.getMetadata(pcjStorage, fluo, queryId));
        }
        return metadata;
    }

    public PcjMetadata getMetadata(PrecomputedJoinStorage pcjStorage, FluoClient fluo, String queryId) throws NotInFluoException, NotInAccumuloException {
        Objects.requireNonNull(pcjStorage);
        Objects.requireNonNull(fluo);
        Objects.requireNonNull(queryId);
        String pcjId = null;
        try (Snapshot snap = fluo.newSnapshot();){
            pcjId = FluoQueryUtils.convertFluoQueryIdToPcjId((String)queryId);
            if (pcjId == null) {
                throw new NotInFluoException("Could not get the PcjMetadata for queryId '" + queryId + "' because a Rya PCJ ID not stored in the Fluo table.");
            }
        }
        try {
            return pcjStorage.getPcjMetadata(pcjId);
        }
        catch (PcjException e) {
            throw new NotInAccumuloException("Could not get the PcjMetadata for queryId '" + queryId + "' because the metadata was missing from the Rya storage.", (Exception)((Object)e));
        }
    }

    public static final class NotInAccumuloException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NotInAccumuloException(String message, Exception cause) {
            super(message, cause);
        }
    }

    public static final class NotInFluoException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NotInFluoException(String message) {
            super(message);
        }
    }
}

