/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.fluo.api;

import com.google.common.base.Preconditions;
import org.apache.fluo.api.client.FluoClient;
import org.apache.rya.indexing.pcj.fluo.api.DeleteFluoPcj;
import org.apache.rya.indexing.pcj.fluo.app.query.UnsupportedQueryException;
import org.apache.rya.indexing.pcj.storage.PeriodicQueryResultStorage;
import org.apache.rya.indexing.pcj.storage.PeriodicQueryStorageException;
import org.apache.rya.periodic.notification.api.PeriodicNotificationClient;
import org.apache.rya.periodic.notification.notification.BasicNotification;

public class DeletePeriodicQuery {
    private FluoClient fluo;
    private PeriodicQueryResultStorage periodicStorage;

    public DeletePeriodicQuery(FluoClient fluo, PeriodicQueryResultStorage periodicStorage) {
        this.fluo = fluo;
        this.periodicStorage = periodicStorage;
    }

    public void deletePeriodicQuery(String pcjId) throws QueryDeletionException {
        Preconditions.checkNotNull((Object)pcjId);
        DeleteFluoPcj deletePcj = new DeleteFluoPcj(1000);
        try {
            deletePcj.deletePcj(this.fluo, pcjId);
            this.periodicStorage.deletePeriodicQuery(pcjId);
        }
        catch (UnsupportedQueryException | PeriodicQueryStorageException e) {
            throw new QueryDeletionException(String.format("Unable to delete the Periodic Query with Id: %s", pcjId), (Exception)e);
        }
    }

    public void deletePeriodicQuery(String pcjId, PeriodicNotificationClient periodicClient) throws QueryDeletionException {
        Preconditions.checkNotNull((Object)periodicClient);
        this.deletePeriodicQuery(pcjId);
        periodicClient.deleteNotification(new BasicNotification(pcjId));
    }

    public static class QueryDeletionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public QueryDeletionException(String message) {
            super(message);
        }

        public QueryDeletionException(String message, Exception e) {
            super(message, e);
        }
    }
}

