/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.fluo.api;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.SnapshotBase;
import org.apache.fluo.api.client.Transaction;
import org.apache.fluo.api.client.TransactionBase;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.Span;
import org.apache.rya.indexing.pcj.fluo.app.NodeType;
import org.apache.rya.indexing.pcj.fluo.app.batch.BatchInformation;
import org.apache.rya.indexing.pcj.fluo.app.batch.BatchInformationDAO;
import org.apache.rya.indexing.pcj.fluo.app.batch.SpanBatchDeleteInformation;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQuery;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQueryMetadataDAO;
import org.apache.rya.indexing.pcj.fluo.app.query.StatementPatternIdManager;
import org.apache.rya.indexing.pcj.fluo.app.query.UnsupportedQueryException;
import org.apache.rya.indexing.pcj.fluo.app.util.FluoQueryUtils;

@DefaultAnnotation(value={NonNull.class})
public class DeleteFluoPcj {
    private final FluoQueryMetadataDAO dao = new FluoQueryMetadataDAO();
    private final int batchSize;

    public DeleteFluoPcj(int batchSize) {
        Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0);
        this.batchSize = batchSize;
    }

    public void deletePcj(FluoClient client, String pcjId) throws UnsupportedQueryException {
        Objects.requireNonNull(client);
        Objects.requireNonNull(pcjId);
        Transaction tx = client.newTransaction();
        List<String> nodeIds = this.getNodeIds(tx, pcjId);
        this.deleteMetadata(tx, nodeIds, pcjId);
        for (String nodeId : nodeIds) {
            this.deleteData(client, nodeId);
        }
    }

    private List<String> getNodeIds(Transaction tx, String pcjId) throws UnsupportedQueryException {
        Objects.requireNonNull(tx);
        Objects.requireNonNull(pcjId);
        String queryId = NodeType.generateNewIdForType((NodeType)NodeType.QUERY, (String)pcjId);
        FluoQuery fluoQuery = this.dao.readFluoQuery((SnapshotBase)tx, queryId);
        return FluoQueryUtils.collectNodeIds((FluoQuery)fluoQuery);
    }

    private void deleteMetadata(Transaction tx, List<String> nodeIds, String pcjId) {
        Objects.requireNonNull(tx);
        Objects.requireNonNull(nodeIds);
        Objects.requireNonNull(pcjId);
        try (Transaction typeTx = tx;){
            HashSet<String> spNodeIds = new HashSet<String>();
            for (String nodeId : nodeIds) {
                NodeType type = (NodeType)NodeType.fromNodeId((String)nodeId).get();
                if (type == NodeType.STATEMENT_PATTERN) {
                    spNodeIds.add(nodeId);
                }
                this.deleteMetadataColumns(typeTx, nodeId, type.getMetaDataColumns());
            }
            StatementPatternIdManager.removeStatementPatternIds((TransactionBase)typeTx, spNodeIds);
            typeTx.commit();
        }
    }

    private void deleteMetadataColumns(Transaction tx, String nodeId, List<Column> columns) {
        Objects.requireNonNull(tx);
        Objects.requireNonNull(columns);
        Objects.requireNonNull(nodeId);
        Bytes row = Bytes.of((String)nodeId);
        for (Column column : columns) {
            tx.delete(row, column);
        }
    }

    private void deleteData(FluoClient client, String nodeId) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(nodeId);
        NodeType type = (NodeType)NodeType.fromNodeId((String)nodeId).get();
        Transaction tx = client.newTransaction();
        Bytes prefixBytes = Bytes.of((String)type.getNodeTypePrefix());
        SpanBatchDeleteInformation batch = SpanBatchDeleteInformation.builder().setColumn(type.getResultColumn()).setSpan(Span.prefix((Bytes)prefixBytes)).setBatchSize(this.batchSize).setNodeId(Optional.of(nodeId)).build();
        BatchInformationDAO.addBatch((TransactionBase)tx, (String)nodeId, (BatchInformation)batch);
        tx.commit();
    }
}

