/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.fluo.api;

import com.google.common.collect.Sets;
import java.util.Optional;
import org.apache.accumulo.core.client.Connector;
import org.apache.fluo.api.client.FluoClient;
import org.apache.rya.api.client.CreatePCJ;
import org.apache.rya.indexing.pcj.fluo.api.CreateFluoPcj;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQuery;
import org.apache.rya.indexing.pcj.fluo.app.query.PeriodicQueryNode;
import org.apache.rya.indexing.pcj.fluo.app.query.UnsupportedQueryException;
import org.apache.rya.indexing.pcj.fluo.app.util.FluoQueryUtils;
import org.apache.rya.indexing.pcj.fluo.app.util.PeriodicQueryUtil;
import org.apache.rya.indexing.pcj.storage.PeriodicQueryResultStorage;
import org.apache.rya.indexing.pcj.storage.PeriodicQueryStorageException;
import org.apache.rya.periodic.notification.api.PeriodicNotificationClient;
import org.apache.rya.periodic.notification.notification.PeriodicNotification;
import org.eclipse.rdf4j.query.MalformedQueryException;

public class CreatePeriodicQuery {
    private FluoClient fluoClient;
    private PeriodicQueryResultStorage periodicStorage;

    public CreatePeriodicQuery(FluoClient fluoClient, PeriodicQueryResultStorage periodicStorage) {
        this.fluoClient = fluoClient;
        this.periodicStorage = periodicStorage;
    }

    public FluoQuery createPeriodicQuery(String sparql) throws PeriodicQueryCreationException {
        try {
            Optional optNode = PeriodicQueryUtil.getPeriodicNode((String)sparql);
            if (optNode.isPresent()) {
                String pcjId = FluoQueryUtils.createNewPcjId();
                CreateFluoPcj createPcj = new CreateFluoPcj();
                FluoQuery fluoQuery = createPcj.createPcj(pcjId, sparql, Sets.newHashSet((Object[])new CreatePCJ.ExportStrategy[]{CreatePCJ.ExportStrategy.PERIODIC}), this.fluoClient);
                this.periodicStorage.createPeriodicQuery(pcjId, sparql);
                return fluoQuery;
            }
            throw new RuntimeException("Invalid PeriodicQuery.  Query must possess a PeriodicQuery Filter.");
        }
        catch (UnsupportedQueryException | PeriodicQueryStorageException | MalformedQueryException e) {
            throw new PeriodicQueryCreationException((Exception)e);
        }
    }

    public FluoQuery createPeriodicQuery(String sparql, PeriodicNotificationClient notificationClient) throws PeriodicQueryCreationException {
        try {
            Optional optNode = PeriodicQueryUtil.getPeriodicNode((String)sparql);
            if (optNode.isPresent()) {
                PeriodicQueryNode periodicNode = (PeriodicQueryNode)optNode.get();
                String pcjId = FluoQueryUtils.createNewPcjId();
                CreateFluoPcj createPcj = new CreateFluoPcj();
                FluoQuery fluoQuery = createPcj.createPcj(pcjId, sparql, Sets.newHashSet((Object[])new CreatePCJ.ExportStrategy[]{CreatePCJ.ExportStrategy.PERIODIC}), this.fluoClient);
                this.periodicStorage.createPeriodicQuery(pcjId, sparql);
                PeriodicNotification notification = PeriodicNotification.builder().id(pcjId).period(periodicNode.getPeriod()).timeUnit(periodicNode.getUnit()).build();
                notificationClient.addNotification(notification);
                return fluoQuery;
            }
            throw new RuntimeException("Invalid PeriodicQuery.  Query must possess a PeriodicQuery Filter.");
        }
        catch (UnsupportedQueryException | PeriodicQueryStorageException | MalformedQueryException e) {
            throw new PeriodicQueryCreationException((Exception)e);
        }
    }

    public FluoQuery withRyaIntegration(String sparql, PeriodicNotificationClient notificationClient, Connector conn, String ryaInstance) throws PeriodicQueryCreationException {
        try {
            Optional optNode = PeriodicQueryUtil.getPeriodicNode((String)sparql);
            if (optNode.isPresent()) {
                PeriodicQueryNode periodicNode = (PeriodicQueryNode)optNode.get();
                String pcjId = FluoQueryUtils.createNewPcjId();
                CreateFluoPcj createPcj = new CreateFluoPcj();
                FluoQuery fluoQuery = createPcj.withRyaIntegration(pcjId, sparql, Sets.newHashSet((Object[])new CreatePCJ.ExportStrategy[]{CreatePCJ.ExportStrategy.PERIODIC}), this.fluoClient, conn, ryaInstance);
                this.periodicStorage.createPeriodicQuery(pcjId, sparql);
                PeriodicNotification notification = PeriodicNotification.builder().id(pcjId).period(periodicNode.getPeriod()).timeUnit(periodicNode.getUnit()).build();
                notificationClient.addNotification(notification);
                return fluoQuery;
            }
            throw new RuntimeException("Invalid PeriodicQuery.  Query must possess a PeriodicQuery Filter.");
        }
        catch (Exception e) {
            throw new PeriodicQueryCreationException(e);
        }
    }

    public static class PeriodicQueryCreationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PeriodicQueryCreationException(Exception e) {
            super(e);
        }

        public PeriodicQueryCreationException(String message, Exception e) {
            super(message, e);
        }

        public PeriodicQueryCreationException(String message) {
            super(message);
        }
    }
}

