/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.kafka.connect.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.rya.kafka.connect.client.RyaKafkaClientCommand;
import org.apache.rya.kafka.connect.client.command.ReadStatementsCommand;
import org.apache.rya.kafka.connect.client.command.WriteStatementsCommand;

@DefaultAnnotation(value={NonNull.class})
public class CLIDriver {
    private static final ImmutableMap<String, RyaKafkaClientCommand> COMMANDS;
    private static final String USAGE;

    public static void main(String[] args) {
        if (args.length == 0 || !COMMANDS.containsKey((Object)args[0])) {
            System.out.println(USAGE);
            System.exit(1);
        }
        String command = args[0];
        String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
        RyaKafkaClientCommand clientCommand = (RyaKafkaClientCommand)COMMANDS.get((Object)command);
        if (!clientCommand.validArguments(commandArgs)) {
            System.out.println(clientCommand.getUsage());
            System.exit(1);
        }
        try {
            clientCommand.execute(commandArgs);
        }
        catch (RyaKafkaClientCommand.ArgumentsException | RyaKafkaClientCommand.ExecutionException e) {
            System.err.println("The command: " + command + " failed to execute properly.");
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static String makeUsage(ImmutableMap<String, RyaKafkaClientCommand> commands) {
        StringBuilder usage = new StringBuilder();
        usage.append("Usage: ").append(CLIDriver.class.getSimpleName()).append(" <command> (<argument> ... )\n");
        usage.append("\n");
        usage.append("Possible Commands:\n");
        ArrayList sortedCommandNames = Lists.newArrayList((Iterable)commands.keySet());
        Collections.sort(sortedCommandNames);
        int maxCommandLength = 0;
        for (String commandName : sortedCommandNames) {
            maxCommandLength = commandName.length() > maxCommandLength ? commandName.length() : maxCommandLength;
        }
        String commandFormat = "    %-" + maxCommandLength + "s - %s\n";
        for (String commandName : sortedCommandNames) {
            String commandDescription = ((RyaKafkaClientCommand)commands.get((Object)commandName)).getDescription();
            usage.append(String.format(commandFormat, commandName, commandDescription));
        }
        return usage.toString();
    }

    static {
        HashSet<Class> commandClasses = new HashSet<Class>();
        commandClasses.add(ReadStatementsCommand.class);
        commandClasses.add(WriteStatementsCommand.class);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Class commandClass : commandClasses) {
            try {
                RyaKafkaClientCommand command = (RyaKafkaClientCommand)commandClass.newInstance();
                builder.put((Object)command.getCommand(), (Object)command);
            }
            catch (IllegalAccessException | InstantiationException e) {
                System.err.println("Could not run the application because a RyaKafkaClientCommand is missing its empty constructor.");
                e.printStackTrace();
            }
        }
        COMMANDS = builder.build();
        USAGE = CLIDriver.makeUsage(COMMANDS);
    }
}

