/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.kafka.connect.client;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;

@DefaultAnnotation(value={NonNull.class})
public interface RyaKafkaClientCommand {
    public String getCommand();

    public String getDescription();

    default public String getUsage() {
        JCommander parser = new JCommander((Object)new KafkaParameters());
        StringBuilder usage = new StringBuilder();
        parser.usage(usage);
        return usage.toString();
    }

    public boolean validArguments(String[] var1);

    public void execute(String[] var1) throws ArgumentsException, ExecutionException;

    public static final class ExecutionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExecutionException(String message) {
            super(message);
        }

        public ExecutionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class ArgumentsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ArgumentsException(String message) {
            super(message);
        }

        public ArgumentsException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class KafkaParameters {
        @Parameter(names={"--bootstrapServers", "-b"}, description="A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.")
        public String bootstrapServers = "localhost:9092";
        @Parameter(names={"--topic", "-t"}, required=true, description="The Kafka topic that will be interacted with.")
        public String topic;
    }
}

