/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.sail.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.AccumuloRyaDAO;
import org.apache.rya.accumulo.instance.AccumuloRyaInstanceDetailsRepository;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.instance.RyaDetailsToConfiguration;
import org.apache.rya.api.layout.TableLayoutStrategy;
import org.apache.rya.api.layout.TablePrefixLayoutStrategy;
import org.apache.rya.api.persist.RyaDAO;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.mongodb.MongoDBRdfConfiguration;
import org.apache.rya.mongodb.MongoDBRyaDAO;
import org.apache.rya.mongodb.MongoSecondaryIndex;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.apache.rya.mongodb.instance.MongoRyaInstanceDetailsRepository;
import org.apache.rya.rdftriplestore.RdfCloudTripleStore;
import org.apache.rya.rdftriplestore.inference.InferenceEngine;
import org.apache.rya.rdftriplestore.inference.InferenceEngineException;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RyaSailFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RyaSailFactory.class);

    public static Sail getInstance(Configuration conf) throws AccumuloException, AccumuloSecurityException, RyaDAOException, InferenceEngineException, SailException {
        Objects.requireNonNull(conf);
        return RyaSailFactory.getRyaSail(conf);
    }

    private static Sail getRyaSail(Configuration config) throws InferenceEngineException, RyaDAOException, AccumuloException, AccumuloSecurityException, SailException {
        AccumuloRdfConfiguration rdfConfig;
        MongoDBRyaDAO dao;
        RdfCloudTripleStore store = new RdfCloudTripleStore();
        String ryaInstance = config.get("query.tblprefix");
        Objects.requireNonNull(ryaInstance, "RyaInstance or table prefix is missing from configuration.query.tblprefix");
        if (ConfigUtils.getUseMongo(config)) {
            MongoDBRdfConfiguration mongoConfig = config instanceof MongoDBRdfConfiguration ? (MongoDBRdfConfiguration)config : new MongoDBRdfConfiguration(config);
            dao = RyaSailFactory.getMongoDAO(mongoConfig);
            rdfConfig = dao.getConf();
        } else {
            rdfConfig = new AccumuloRdfConfiguration(config);
            String user = rdfConfig.get("sc.cloudbase.username");
            String pswd = rdfConfig.get("sc.cloudbase.password");
            Objects.requireNonNull(user, "Accumulo user name is missing from configuration.sc.cloudbase.username");
            Objects.requireNonNull(pswd, "Accumulo user password is missing from configuration.sc.cloudbase.password");
            rdfConfig.setTableLayoutStrategy((TableLayoutStrategy)new TablePrefixLayoutStrategy(ryaInstance));
            RyaSailFactory.updateAccumuloConfig(rdfConfig, user, pswd, ryaInstance);
            dao = RyaSailFactory.getAccumuloDAO(rdfConfig);
        }
        store.setRyaDAO((RyaDAO)dao);
        rdfConfig.setTablePrefix(ryaInstance);
        if (rdfConfig.isInfer().booleanValue()) {
            InferenceEngine inferenceEngine = new InferenceEngine();
            inferenceEngine.setConf((RdfCloudTripleStoreConfiguration)rdfConfig);
            inferenceEngine.setRyaDAO((RyaDAO)dao);
            inferenceEngine.init();
            store.setInferenceEngine(inferenceEngine);
        }
        store.initialize();
        return store;
    }

    private static MongoClient createMongoClient(MongoDBRdfConfiguration mongoConf) throws ConfigurationRuntimeException, MongoException {
        int port;
        Objects.requireNonNull(mongoConf);
        Objects.requireNonNull(mongoConf.getMongoHostname());
        Objects.requireNonNull(mongoConf.getMongoPort());
        Objects.requireNonNull(mongoConf.getMongoDBName());
        try {
            port = Integer.parseInt(mongoConf.getMongoPort());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationRuntimeException("Port '" + mongoConf.getMongoPort() + "' must be an integer.");
        }
        ServerAddress server = new ServerAddress(mongoConf.getMongoHostname(), port);
        String username = mongoConf.getMongoUser();
        String database = mongoConf.getMongoDBName();
        String password = mongoConf.getMongoPassword();
        if (username != null && password != null) {
            MongoCredential cred = MongoCredential.createCredential((String)username, (String)database, (char[])password.toCharArray());
            MongoClientOptions options = new MongoClientOptions.Builder().build();
            return new MongoClient(server, cred, options);
        }
        return new MongoClient(server);
    }

    public static AccumuloRyaDAO getAccumuloDAO(AccumuloRdfConfiguration config) throws AccumuloException, AccumuloSecurityException, RyaDAOException {
        Connector connector = ConfigUtils.getConnector((Configuration)config);
        AccumuloRyaDAO dao = new AccumuloRyaDAO();
        dao.setConnector(connector);
        ConfigUtils.setIndexers((RdfCloudTripleStoreConfiguration)config);
        dao.setConf(config);
        dao.init();
        return dao;
    }

    public static AccumuloRyaDAO getAccumuloDAOWithUpdatedConfig(AccumuloRdfConfiguration config) throws AccumuloException, AccumuloSecurityException, RyaDAOException {
        String ryaInstance = config.get("query.tblprefix");
        Objects.requireNonNull(ryaInstance, "RyaInstance or table prefix is missing from configuration.query.tblprefix");
        String user = config.get("sc.cloudbase.username");
        String pswd = config.get("sc.cloudbase.password");
        Objects.requireNonNull(user, "Accumulo user name is missing from configuration.sc.cloudbase.username");
        Objects.requireNonNull(pswd, "Accumulo user password is missing from configuration.sc.cloudbase.password");
        config.setTableLayoutStrategy((TableLayoutStrategy)new TablePrefixLayoutStrategy(ryaInstance));
        RyaSailFactory.updateAccumuloConfig(config, user, pswd, ryaInstance);
        return RyaSailFactory.getAccumuloDAO(config);
    }

    public static void updateAccumuloConfig(AccumuloRdfConfiguration config, String user, String pswd, String ryaInstance) throws AccumuloException, AccumuloSecurityException {
        try {
            Connector connector = ConfigUtils.getConnector((Configuration)config);
            AccumuloRyaInstanceDetailsRepository ryaDetailsRepo = new AccumuloRyaInstanceDetailsRepository(connector, ryaInstance);
            RyaDetailsToConfiguration.addRyaDetailsToConfiguration((RyaDetails)ryaDetailsRepo.getRyaInstanceDetails(), (Configuration)config);
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            LOG.info("Instance does not have a rya details collection, skipping.");
        }
    }

    public static MongoDBRyaDAO getMongoDAO(MongoDBRdfConfiguration mongoConfig) throws RyaDAOException {
        MongoClient client = RyaSailFactory.createMongoClient(mongoConfig);
        ConfigUtils.setIndexers((RdfCloudTripleStoreConfiguration)mongoConfig);
        try {
            MongoRyaInstanceDetailsRepository ryaDetailsRepo = new MongoRyaInstanceDetailsRepository(client, mongoConfig.getRyaInstanceName());
            RyaDetailsToConfiguration.addRyaDetailsToConfiguration((RyaDetails)ryaDetailsRepo.getRyaInstanceDetails(), (Configuration)mongoConfig);
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            LOG.info("Instance does not have a rya details collection, skipping.");
        }
        StatefulMongoDBRdfConfiguration statefulConfig = new StatefulMongoDBRdfConfiguration((Configuration)mongoConfig, client);
        List indexers = statefulConfig.getInstances("ac.additional.indexers", MongoSecondaryIndex.class);
        statefulConfig.setIndexers(indexers);
        MongoDBRyaDAO mongoDao = new MongoDBRyaDAO();
        mongoDao.setConf(statefulConfig);
        mongoDao.init();
        return mongoDao;
    }
}

