/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.sail.config;

import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.GraphUtil;
import org.eclipse.rdf4j.model.util.GraphUtilException;
import org.eclipse.rdf4j.sail.config.AbstractSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;

@Deprecated
public class RyaAccumuloSailConfig
extends AbstractSailImplConfig {
    public static final String NAMESPACE = "http://rya.apache.org/RyaAccumuloSail/Config#";
    public static final IRI INSTANCE;
    public static final IRI USER;
    public static final IRI PASSWORD;
    public static final IRI ZOOKEEPERS;
    public static final IRI IS_MOCK;
    private String user = "root";
    private String password = "root";
    private String instance = "dev";
    private String zookeepers = "zoo1,zoo2,zoo3";
    private boolean isMock = false;

    public RyaAccumuloSailConfig() {
        super("rya:RyaAccumuloSail");
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getZookeepers() {
        return this.zookeepers;
    }

    public void setZookeepers(String zookeepers) {
        this.zookeepers = zookeepers;
    }

    public boolean isMock() {
        return this.isMock;
    }

    public void setMock(boolean isMock) {
        this.isMock = isMock;
    }

    public AccumuloRdfConfiguration toRdfConfiguation() {
        AccumuloRdfConfiguration conf = new AccumuloRdfConfiguration();
        return conf;
    }

    public void validate() throws SailConfigException {
        super.validate();
    }

    public Resource export(Model model) {
        Resource implNode = super.export(model);
        ValueFactory v = model.getValueFactory();
        model.add(implNode, USER, (Value)v.createLiteral(this.user), new Resource[0]);
        model.add(implNode, PASSWORD, (Value)v.createLiteral(this.password), new Resource[0]);
        model.add(implNode, INSTANCE, (Value)v.createLiteral(this.instance), new Resource[0]);
        model.add(implNode, ZOOKEEPERS, (Value)v.createLiteral(this.zookeepers), new Resource[0]);
        model.add(implNode, IS_MOCK, (Value)v.createLiteral(this.isMock), new Resource[0]);
        return implNode;
    }

    public void parse(Model model, Resource implNode) throws SailConfigException {
        super.parse(model, implNode);
        System.out.println("parsing");
        try {
            Literal mockLit;
            Literal zooLit;
            Literal instLit;
            Literal pwdLit;
            Literal userLit = GraphUtil.getOptionalObjectLiteral((Graph)model, (Resource)implNode, (IRI)USER);
            if (userLit != null) {
                this.setUser(userLit.getLabel());
            }
            if ((pwdLit = GraphUtil.getOptionalObjectLiteral((Graph)model, (Resource)implNode, (IRI)PASSWORD)) != null) {
                this.setPassword(pwdLit.getLabel());
            }
            if ((instLit = GraphUtil.getOptionalObjectLiteral((Graph)model, (Resource)implNode, (IRI)INSTANCE)) != null) {
                this.setInstance(instLit.getLabel());
            }
            if ((zooLit = GraphUtil.getOptionalObjectLiteral((Graph)model, (Resource)implNode, (IRI)ZOOKEEPERS)) != null) {
                this.setZookeepers(zooLit.getLabel());
            }
            if ((mockLit = GraphUtil.getOptionalObjectLiteral((Graph)model, (Resource)implNode, (IRI)IS_MOCK)) != null) {
                this.setMock(Boolean.parseBoolean(mockLit.getLabel()));
            }
        }
        catch (GraphUtilException e) {
            throw new SailConfigException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        SimpleValueFactory factory = SimpleValueFactory.getInstance();
        USER = factory.createIRI(NAMESPACE, "user");
        PASSWORD = factory.createIRI(NAMESPACE, "password");
        INSTANCE = factory.createIRI(NAMESPACE, "instance");
        ZOOKEEPERS = factory.createIRI(NAMESPACE, "zookeepers");
        IS_MOCK = factory.createIRI(NAMESPACE, "isMock");
    }
}

