/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.statement.metadata.matching;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.indexing.external.matching.AbstractExternalSetOptimizer;
import org.apache.rya.indexing.external.matching.BasicRater;
import org.apache.rya.indexing.external.matching.ExternalSetMatcher;
import org.apache.rya.indexing.external.matching.ExternalSetProvider;
import org.apache.rya.indexing.external.matching.QueryNodeListRater;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.indexing.statement.metadata.matching.StatementMetadataExternalSetMatcherFactory;
import org.apache.rya.indexing.statement.metadata.matching.StatementMetadataExternalSetProvider;
import org.apache.rya.indexing.statement.metadata.matching.StatementMetadataNode;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class StatementMetadataOptimizer
extends AbstractExternalSetOptimizer<StatementMetadataNode<?>>
implements Configurable {
    private StatementMetadataExternalSetMatcherFactory factory = new StatementMetadataExternalSetMatcherFactory();
    private RdfCloudTripleStoreConfiguration conf;
    public boolean init = false;
    public StatementMetadataExternalSetProvider provider;

    public StatementMetadataOptimizer() {
    }

    public StatementMetadataOptimizer(RdfCloudTripleStoreConfiguration conf) {
        this.setConf((Configuration)conf);
    }

    public final void setConf(Configuration conf) {
        Preconditions.checkNotNull((Object)conf);
        if (!this.init) {
            try {
                this.conf = (RdfCloudTripleStoreConfiguration)conf;
                this.provider = new StatementMetadataExternalSetProvider(this.conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.init = true;
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        if (!this.init) {
            throw new IllegalStateException("Optimizer has not been properly initialized.  Configuration must be set to initialize this class.");
        }
        super.optimize(tupleExpr, dataset, bindings);
    }

    @Override
    protected ExternalSetMatcher<StatementMetadataNode<?>> getMatcher(QuerySegment<StatementMetadataNode<?>> segment) {
        return this.factory.getMatcher(segment);
    }

    @Override
    protected ExternalSetProvider<StatementMetadataNode<?>> getProvider() {
        return this.provider;
    }

    @Override
    protected Optional<QueryNodeListRater> getNodeListRater(QuerySegment<StatementMetadataNode<?>> segment) {
        return Optional.of((Object)new BasicRater(segment.getOrderedNodes()));
    }
}

