/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.statement.metadata.matching;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.domain.StatementMetadata;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.persist.query.RyaQueryEngine;
import org.apache.rya.api.resolver.RdfToRyaConversions;
import org.apache.rya.api.resolver.RyaToRdfConversions;
import org.apache.rya.indexing.statement.metadata.matching.OWLReify;
import org.apache.rya.indexing.statement.metadata.matching.RyaQueryEngineFactory;
import org.apache.rya.rdftriplestore.evaluation.ExternalBatchingIterator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;

public class StatementMetadataNode<C extends RdfCloudTripleStoreConfiguration>
extends ExternalSet
implements ExternalBatchingIterator {
    private static final RyaIRI TYPE_ID_URI = new RyaIRI(RDF.TYPE.toString());
    private static final RyaIRI SUBJ_ID_URI = new RyaIRI(OWLReify.SOURCE.toString());
    private static final RyaIRI PRED_ID_URI = new RyaIRI(OWLReify.PROPERTY.toString());
    private static final RyaIRI OBJ_ID_URI = new RyaIRI(OWLReify.TARGET.toString());
    private static final RyaIRI STATEMENT_ID_URI = new RyaIRI(OWLReify.ANNOTATION.toString());
    private StatementPattern statement;
    private Map<RyaIRI, Var> properties;
    private final Collection<StatementPattern> patterns;
    private final List<RyaIRI> uriList = Arrays.asList(TYPE_ID_URI, SUBJ_ID_URI, PRED_ID_URI, OBJ_ID_URI);
    private final C conf;
    private Set<String> bindingNames;
    private RyaQueryEngine<C> queryEngine;

    public StatementMetadataNode(Collection<StatementPattern> patterns, C conf) {
        this.conf = conf;
        this.patterns = patterns;
        StatementMetadataNode.verifySameSubjects(patterns);
        StatementMetadataNode.verifyAllPredicatesAreConstants(patterns);
        boolean correctForm = StatementMetadataNode.verifyHasCorrectTypePattern(patterns);
        if (!correctForm) {
            throw new IllegalArgumentException("Invalid reified StatementPatterns.");
        }
        this.setStatementPatternAndProperties(patterns);
    }

    public Collection<StatementPattern> getReifiedStatementPatterns() {
        return this.patterns;
    }

    private static void verifySameSubjects(Collection<StatementPattern> patterns) throws IllegalStateException {
        Objects.requireNonNull(patterns);
        Iterator<StatementPattern> it = patterns.iterator();
        Var subject = it.next().getSubjectVar();
        while (it.hasNext()) {
            StatementPattern pattern = it.next();
            if (pattern.getSubjectVar().equals((Object)subject)) continue;
            throw new IllegalStateException("At least one of the patterns has a different subject from the others. All subjects must be the same.");
        }
    }

    private static void verifyAllPredicatesAreConstants(Collection<StatementPattern> patterns) throws IllegalStateException {
        Objects.requireNonNull(patterns);
        for (StatementPattern pattern : patterns) {
            if (pattern.getPredicateVar().isConstant()) continue;
            throw new IllegalStateException("The Predicate of a Statement Pattern must be constant. Pattern: " + pattern);
        }
    }

    public static boolean verifyHasCorrectTypePattern(Collection<StatementPattern> patterns) throws IllegalStateException {
        Objects.requireNonNull(patterns);
        boolean subjFound = false;
        boolean objFound = false;
        boolean predFound = false;
        boolean statementFound = false;
        boolean valid = true;
        boolean contextSet = false;
        Var context = null;
        for (StatementPattern pattern : patterns) {
            RyaIRI predicate = new RyaIRI(pattern.getPredicateVar().getValue().toString());
            if (!contextSet) {
                context = pattern.getContextVar();
                contextSet = true;
            } else if (context != null && !context.equals((Object)pattern.getContextVar())) {
                return false;
            }
            if (predicate.equals((Object)TYPE_ID_URI)) {
                Value objectValue = pattern.getObjectVar().getValue();
                if (objectValue != null) {
                    RyaIRI statementID = new RyaIRI(objectValue.stringValue());
                    if (statementID.equals((Object)STATEMENT_ID_URI)) {
                        statementFound = true;
                    } else {
                        valid = false;
                    }
                } else {
                    valid = false;
                }
            }
            if (predicate.equals((Object)SUBJ_ID_URI)) {
                if (!subjFound) {
                    subjFound = true;
                } else {
                    valid = false;
                }
            }
            if (predicate.equals((Object)PRED_ID_URI)) {
                if (!predFound) {
                    predFound = true;
                } else {
                    valid = false;
                }
            }
            if (!predicate.equals((Object)OBJ_ID_URI)) continue;
            if (!objFound) {
                objFound = true;
                continue;
            }
            valid = false;
        }
        return valid && statementFound && subjFound && predFound && objFound;
    }

    private void setStatementPatternAndProperties(Collection<StatementPattern> patterns) {
        StatementPattern sp = new StatementPattern();
        HashMap<RyaIRI, Var> properties = new HashMap<RyaIRI, Var>();
        for (StatementPattern pattern : patterns) {
            RyaIRI predicate = new RyaIRI(pattern.getPredicateVar().getValue().toString());
            if (!this.uriList.contains(predicate)) {
                Var objVar = pattern.getObjectVar();
                properties.put(predicate, objVar);
                continue;
            }
            if (predicate.equals((Object)SUBJ_ID_URI)) {
                sp.setContextVar(pattern.getContextVar());
                sp.setSubjectVar(pattern.getObjectVar());
            }
            if (predicate.equals((Object)PRED_ID_URI)) {
                sp.setPredicateVar(pattern.getObjectVar());
            }
            if (!predicate.equals((Object)OBJ_ID_URI)) continue;
            sp.setObjectVar(pattern.getObjectVar());
        }
        this.statement = sp;
        this.properties = properties;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Collection<BindingSet> bindingset) throws QueryEvaluationException {
        CloseableIteration iteration;
        if (bindingset.size() == 0) {
            return new EmptyIteration();
        }
        this.queryEngine = RyaQueryEngineFactory.getQueryEngine(this.conf);
        HashSet<RdfCloudTripleStoreUtils.CustomEntry> statements = new HashSet<RdfCloudTripleStoreUtils.CustomEntry>();
        for (BindingSet bs : bindingset) {
            statements.add(new RdfCloudTripleStoreUtils.CustomEntry((Object)this.getRyaStatementFromBindings(bs), (Object)bs));
        }
        try {
            iteration = this.queryEngine.queryWithBindingSet(statements, this.conf);
        }
        catch (RyaDAOException e) {
            throw new RuntimeException(e);
        }
        return new PropertyFilterAndBindingSetJoinIteration((CloseableIteration<? extends Map.Entry<RyaStatement, BindingSet>, RyaDAOException>)iteration, this.properties, this.statement);
    }

    private RyaStatement getRyaStatementFromBindings(BindingSet bs) {
        Value subjValue = this.getVarValue(this.statement.getSubjectVar(), bs);
        Value predValue = this.getVarValue(this.statement.getPredicateVar(), bs);
        Value objValue = this.getVarValue(this.statement.getObjectVar(), bs);
        Value contextValue = this.getVarValue(this.statement.getContextVar(), bs);
        RyaIRI subj = null;
        RyaIRI pred = null;
        RyaType obj = null;
        RyaIRI context = null;
        if (subjValue != null) {
            Preconditions.checkArgument((boolean)(subjValue instanceof IRI));
            subj = RdfToRyaConversions.convertIRI((IRI)((IRI)subjValue));
        }
        if (predValue != null) {
            Preconditions.checkArgument((boolean)(predValue instanceof IRI));
            pred = RdfToRyaConversions.convertIRI((IRI)((IRI)predValue));
        }
        if (objValue != null) {
            obj = RdfToRyaConversions.convertValue((Value)objValue);
        }
        if (contextValue != null) {
            context = RdfToRyaConversions.convertIRI((IRI)((IRI)contextValue));
        }
        return new RyaStatement(subj, pred, obj, context);
    }

    private Value getVarValue(Var var, BindingSet bindings) {
        if (var == null) {
            return null;
        }
        if (var.hasValue()) {
            return var.getValue();
        }
        return bindings.getValue(var.getName());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) throws QueryEvaluationException {
        return this.evaluate(Collections.singleton(bindings));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof StatementMetadataNode) {
            StatementMetadataNode meta = (StatementMetadataNode)((Object)other);
            if (meta.patterns.size() != this.patterns.size()) {
                return false;
            }
            if (this.patterns.size() != meta.patterns.size()) {
                return false;
            }
            HashSet<StatementPattern> thisSet = new HashSet<StatementPattern>(this.patterns);
            HashSet<StatementPattern> thatSet = new HashSet<StatementPattern>(meta.patterns);
            return thisSet.equals(thatSet);
        }
        return false;
    }

    public int hashCode() {
        int hashcode = 0;
        for (StatementPattern sp : this.patterns) {
            hashcode += sp.hashCode();
        }
        return hashcode;
    }

    public Set<String> getBindingNames() {
        if (this.bindingNames == null) {
            this.bindingNames = this.getVariableNames();
        }
        return this.bindingNames;
    }

    public Set<String> getAssuredBindingNames() {
        return this.getBindingNames();
    }

    public String getSignature() {
        return "StatementMetadataNode(" + Joiner.on((String)",").join(this.getBindingNames()) + ")";
    }

    public String toString() {
        return this.getSignature();
    }

    private Set<String> getVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (StatementPattern pattern : this.patterns) {
            for (Var var : pattern.getVarList()) {
                if (var.getValue() != null) continue;
                vars.add(var.getName());
            }
        }
        return vars;
    }

    class PropertyFilterAndBindingSetJoinIteration
    implements CloseableIteration<BindingSet, QueryEvaluationException> {
        private final CloseableIteration<? extends Map.Entry<RyaStatement, BindingSet>, RyaDAOException> statements;
        private final Map<RyaIRI, Var> properties;
        private final StatementPattern sp;
        private BindingSet next;
        private boolean hasNextCalled = false;
        private boolean hasNext = false;

        public PropertyFilterAndBindingSetJoinIteration(CloseableIteration<? extends Map.Entry<RyaStatement, BindingSet>, RyaDAOException> statements, Map<RyaIRI, Var> properties, StatementPattern sp) {
            this.statements = statements;
            this.properties = properties;
            this.sp = sp;
        }

        public boolean hasNext() throws QueryEvaluationException {
            if (!this.hasNextCalled) {
                this.hasNextCalled = true;
                this.hasNext = false;
                try {
                    Optional<BindingSet> bs = this.getNext();
                    if (bs.isPresent()) {
                        this.next = bs.get();
                        this.hasNext = true;
                    }
                    if (!this.hasNext) {
                        StatementMetadataNode.this.queryEngine.close();
                    }
                    return this.hasNext;
                }
                catch (IOException | RyaDAOException e) {
                    throw new QueryEvaluationException(e);
                }
            }
            return this.hasNext;
        }

        public BindingSet next() throws QueryEvaluationException {
            if (this.hasNextCalled) {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNextCalled = false;
                return this.next;
            }
            this.hasNext();
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNextCalled = false;
            return this.next;
        }

        public void remove() throws QueryEvaluationException {
            throw new UnsupportedOperationException();
        }

        public void close() throws QueryEvaluationException {
            try {
                this.statements.close();
            }
            catch (RyaDAOException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }

        private Optional<BindingSet> getNext() throws RyaDAOException {
            Optional<BindingSet> optionalBs = Optional.empty();
            while (this.statements.hasNext() && !optionalBs.isPresent()) {
                Map.Entry next = (Map.Entry)this.statements.next();
                optionalBs = this.buildBindingSet((RyaStatement)next.getKey(), (BindingSet)next.getValue());
            }
            return optionalBs;
        }

        private Optional<BindingSet> buildBindingSet(RyaStatement statement, BindingSet bindingSet) {
            QueryBindingSet bs = new QueryBindingSet();
            Optional<BindingSet> optPropBs = this.buildPropertyBindingSet(statement);
            if (!optPropBs.isPresent()) {
                return Optional.empty();
            }
            BindingSet propBs = optPropBs.get();
            BindingSet spBs = this.buildBindingSetFromStatementPattern(statement);
            if (!this.canJoinBindingSets(spBs, propBs)) {
                return Optional.empty();
            }
            bs.addAll(spBs);
            bs.addAll(propBs);
            if (!this.canJoinBindingSets((BindingSet)bs, bindingSet)) {
                return Optional.empty();
            }
            bs.addAll(bindingSet);
            return Optional.of(bs);
        }

        private Optional<BindingSet> buildPropertyBindingSet(RyaStatement statement) {
            StatementMetadata metadata = statement.getMetadata();
            Map statementProps = metadata.getMetadata();
            if (statementProps.size() < this.properties.size()) {
                return Optional.empty();
            }
            QueryBindingSet bs = new QueryBindingSet();
            for (Map.Entry<RyaIRI, Var> entry : this.properties.entrySet()) {
                RyaIRI key = entry.getKey();
                Var var = entry.getValue();
                if (!statementProps.containsKey(key)) {
                    return Optional.empty();
                }
                Value val = RyaToRdfConversions.convertValue((RyaType)((RyaType)statementProps.get(key)));
                if (var.getValue() == null) {
                    bs.addBinding(var.getName(), val);
                    continue;
                }
                if (var.getValue().equals(val)) continue;
                return Optional.empty();
            }
            return Optional.of(bs);
        }

        private BindingSet buildBindingSetFromStatementPattern(RyaStatement statement) {
            Var subjVar = this.sp.getSubjectVar();
            Var predVar = this.sp.getPredicateVar();
            Var objVar = this.sp.getObjectVar();
            Var contextVar = this.sp.getContextVar();
            QueryBindingSet bs = new QueryBindingSet();
            if (subjVar.getValue() == null) {
                bs.addBinding(subjVar.getName(), RyaToRdfConversions.convertValue((RyaType)statement.getSubject()));
            }
            if (predVar.getValue() == null) {
                bs.addBinding(predVar.getName(), RyaToRdfConversions.convertValue((RyaType)statement.getPredicate()));
            }
            if (objVar.getValue() == null) {
                bs.addBinding(objVar.getName(), RyaToRdfConversions.convertValue((RyaType)statement.getObject()));
            }
            if (contextVar != null && contextVar.getValue() == null) {
                bs.addBinding(contextVar.getName(), RyaToRdfConversions.convertValue((RyaType)statement.getContext()));
            }
            return bs;
        }

        private boolean canJoinBindingSets(BindingSet bs1, BindingSet bs2) {
            for (Binding b : bs1) {
                String name = b.getName();
                Value val = b.getValue();
                if (!bs2.hasBinding(name) || bs2.getValue(name).equals(val)) continue;
                return false;
            }
            return true;
        }
    }
}

