/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.statement.metadata.matching;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.resolver.RdfToRyaConversions;
import org.apache.rya.indexing.external.matching.ExternalSetProvider;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.indexing.statement.metadata.matching.OWLReify;
import org.apache.rya.indexing.statement.metadata.matching.StatementMetadataNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;

public class StatementMetadataExternalSetProvider
implements ExternalSetProvider<StatementMetadataNode<?>> {
    private List<RyaIRI> expectedURI = Arrays.asList(RdfToRyaConversions.convertIRI((IRI)OWLReify.SOURCE), RdfToRyaConversions.convertIRI((IRI)OWLReify.PROPERTY), RdfToRyaConversions.convertIRI((IRI)OWLReify.TARGET), RdfToRyaConversions.convertIRI((IRI)RDF.TYPE));
    private Multimap<Var, StatementPattern> reifiedQueries;
    private Set<RyaIRI> metadataProperties;
    private RdfCloudTripleStoreConfiguration conf;

    public StatementMetadataExternalSetProvider(RdfCloudTripleStoreConfiguration conf) {
        this.metadataProperties = conf.getStatementMetadataProperties();
        this.conf = conf;
    }

    @Override
    public List<StatementMetadataNode<?>> getExternalSets(QuerySegment<StatementMetadataNode<?>> segment) {
        this.reifiedQueries = HashMultimap.create();
        ArrayList metadataList = new ArrayList();
        for (QueryModelNode node : segment.getUnOrderedNodes()) {
            if (!(node instanceof StatementPattern)) continue;
            StatementPattern sp = (StatementPattern)node;
            this.reifiedQueries.put((Object)sp.getSubjectVar(), (Object)sp);
        }
        for (Var var : this.reifiedQueries.keySet()) {
            Set<StatementPattern> patterns = this.removeInvalidProperties(this.reifiedQueries.get((Object)var));
            if (!StatementMetadataNode.verifyHasCorrectTypePattern(patterns)) continue;
            metadataList.add(new StatementMetadataNode<RdfCloudTripleStoreConfiguration>(patterns, this.conf));
        }
        return metadataList;
    }

    @Override
    public Iterator<List<StatementMetadataNode<?>>> getExternalSetCombos(QuerySegment<StatementMetadataNode<?>> segment) {
        HashSet combos = new HashSet();
        combos.add(this.getExternalSets(segment));
        return combos.iterator();
    }

    private Set<StatementPattern> removeInvalidProperties(Collection<StatementPattern> patterns) {
        HashSet<StatementPattern> finalPatterns = new HashSet<StatementPattern>();
        for (StatementPattern pattern : patterns) {
            RyaIRI uri;
            Var var = pattern.getPredicateVar();
            if (var.getValue() == null || !(var.getValue() instanceof IRI) || !this.expectedURI.contains(uri = RdfToRyaConversions.convertIRI((IRI)((IRI)var.getValue()))) && !this.metadataProperties.contains(uri)) continue;
            finalPatterns.add(pattern);
        }
        return finalPatterns;
    }
}

