/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.statement.metadata.matching;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.query.AccumuloRyaQueryEngine;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.persist.query.RyaQueryEngine;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.mongodb.MongoDBQueryEngine;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;

public class RyaQueryEngineFactory {
    public static <C extends RdfCloudTripleStoreConfiguration> RyaQueryEngine<C> getQueryEngine(RdfCloudTripleStoreConfiguration conf) {
        if (conf instanceof AccumuloRdfConfiguration) {
            Connector conn;
            MockInstance instance;
            AccumuloRdfConfiguration aConf = (AccumuloRdfConfiguration)conf;
            String instanceName = aConf.get("sc.cloudbase.instancename");
            String user = aConf.get("sc.cloudbase.username");
            String password = aConf.get("sc.cloudbase.password");
            if (aConf.getBoolean(".useMockInstance", false)) {
                instance = new MockInstance(instanceName);
            } else {
                String zookeepers = aConf.get("sc.cloudbase.zookeepers");
                instance = new ZooKeeperInstance(instanceName, zookeepers);
            }
            try {
                conn = instance.getConnector(user, (AuthenticationToken)new PasswordToken((CharSequence)password));
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                throw new RuntimeException(e);
            }
            return new AccumuloRyaQueryEngine(conn, aConf);
        }
        if (conf instanceof StatefulMongoDBRdfConfiguration && ConfigUtils.getUseMongo((Configuration)conf)) {
            StatefulMongoDBRdfConfiguration mongoConf = (StatefulMongoDBRdfConfiguration)conf;
            MongoDBQueryEngine mongoQueryEngine = new MongoDBQueryEngine();
            mongoQueryEngine.setConf(mongoConf);
            return mongoQueryEngine;
        }
        throw new IllegalArgumentException("Invalid configuration type.");
    }
}

