/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.smarturi.duplication.conf;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.rya.indexing.smarturi.duplication.Tolerance;
import org.apache.rya.indexing.smarturi.duplication.ToleranceType;

public class DuplicateDataConfig {
    public static final String DEFAULT_CONFIG_FILE_PATH = "conf/duplicate_data_detection_config.xml";
    private Tolerance booleanTolerance;
    private Tolerance byteTolerance;
    private Tolerance dateTolerance;
    private Tolerance doubleTolerance;
    private Tolerance floatTolerance;
    private Tolerance integerTolerance;
    private Tolerance longTolerance;
    private Tolerance shortTolerance;
    private Tolerance stringTolerance;
    private Tolerance uriTolerance;
    private Map<String, List<String>> equivalentTermsMap;
    private boolean isDetectionEnabled;

    public DuplicateDataConfig() throws ConfigurationException {
        this(new XMLConfiguration(DEFAULT_CONFIG_FILE_PATH));
    }

    public DuplicateDataConfig(String xmlFileLocation) throws ConfigurationException {
        this(new XMLConfiguration(Objects.requireNonNull(xmlFileLocation)));
    }

    public DuplicateDataConfig(XMLConfiguration xmlConfig) throws ConfigurationException {
        Objects.requireNonNull(xmlConfig);
        Tolerance booleanTolerance = DuplicateDataConfig.parseTolerance("tolerances.booleanTolerance", xmlConfig);
        Tolerance byteTolerance = DuplicateDataConfig.parseTolerance("tolerances.byteTolerance", xmlConfig);
        Tolerance dateTolerance = DuplicateDataConfig.parseTolerance("tolerances.dateTolerance", xmlConfig);
        Tolerance doubleTolerance = DuplicateDataConfig.parseTolerance("tolerances.doubleTolerance", xmlConfig);
        Tolerance floatTolerance = DuplicateDataConfig.parseTolerance("tolerances.floatTolerance", xmlConfig);
        Tolerance integerTolerance = DuplicateDataConfig.parseTolerance("tolerances.integerTolerance", xmlConfig);
        Tolerance longTolerance = DuplicateDataConfig.parseTolerance("tolerances.longTolerance", xmlConfig);
        Tolerance shortTolerance = DuplicateDataConfig.parseTolerance("tolerances.shortTolerance", xmlConfig);
        Tolerance stringTolerance = DuplicateDataConfig.parseTolerance("tolerances.stringTolerance", xmlConfig);
        Tolerance uriTolerance = DuplicateDataConfig.parseTolerance("tolerances.uriTolerance", xmlConfig);
        Map<String, List<String>> equivalentTermsMap = DuplicateDataConfig.parseEquivalentTermsMap(xmlConfig);
        boolean isDetectionEnabled = xmlConfig.getBoolean("enableDetection", false);
        this.init(booleanTolerance, byteTolerance, dateTolerance, doubleTolerance, floatTolerance, integerTolerance, longTolerance, shortTolerance, stringTolerance, uriTolerance, equivalentTermsMap, isDetectionEnabled);
    }

    public DuplicateDataConfig(Tolerance booleanTolerance, Tolerance byteTolerance, Tolerance dateTolerance, Tolerance doubleTolerance, Tolerance floatTolerance, Tolerance integerTolerance, Tolerance longTolerance, Tolerance shortTolerance, Tolerance stringTolerance, Tolerance uriTolerance, Map<String, List<String>> equivalentTermsMap, boolean isDetectionEnabled) {
        this.init(booleanTolerance, byteTolerance, dateTolerance, doubleTolerance, floatTolerance, integerTolerance, longTolerance, shortTolerance, stringTolerance, uriTolerance, equivalentTermsMap, isDetectionEnabled);
    }

    private void init(Tolerance booleanTolerance, Tolerance byteTolerance, Tolerance dateTolerance, Tolerance doubleTolerance, Tolerance floatTolerance, Tolerance integerTolerance, Tolerance longTolerance, Tolerance shortTolerance, Tolerance stringTolerance, Tolerance uriTolerance, Map<String, List<String>> equivalentTermsMap, boolean isDetectionEnabled) {
        this.booleanTolerance = booleanTolerance;
        this.byteTolerance = byteTolerance;
        this.dateTolerance = dateTolerance;
        this.doubleTolerance = doubleTolerance;
        this.floatTolerance = floatTolerance;
        this.integerTolerance = integerTolerance;
        this.longTolerance = longTolerance;
        this.shortTolerance = shortTolerance;
        this.stringTolerance = stringTolerance;
        this.uriTolerance = uriTolerance;
        this.equivalentTermsMap = Objects.requireNonNull(equivalentTermsMap);
        this.isDetectionEnabled = isDetectionEnabled;
    }

    private static Tolerance parseTolerance(String key, XMLConfiguration xmlConfig) throws ConfigurationException {
        String type = xmlConfig.getString(key + ".type", null);
        ToleranceType toleranceType = ToleranceType.getToleranceTypeByName(type);
        Double doubleValue = null;
        if (toleranceType != null) {
            switch (toleranceType) {
                case PERCENTAGE: {
                    String value = xmlConfig.getString(key + ".value", null);
                    if (value != null && value.contains("%")) {
                        try {
                            Number number = NumberFormat.getPercentInstance().parse(value);
                            doubleValue = number.doubleValue();
                        }
                        catch (ParseException e) {
                            throw new ConfigurationException((Throwable)e);
                        }
                    } else {
                        doubleValue = xmlConfig.getDouble(key + ".value", null);
                    }
                    if (doubleValue == null) break;
                    if (doubleValue < 0.0) {
                        throw new ConfigurationException("The " + (Object)((Object)toleranceType) + " tolerance type for \"" + key + "\" must be a positive value. Found this value: " + doubleValue);
                    }
                    if (!(doubleValue > 1.0)) break;
                    throw new ConfigurationException("The " + (Object)((Object)toleranceType) + " tolerance type for \"" + key + "\" can NOT be greater than 100%. Found this value: " + doubleValue);
                }
                case DIFFERENCE: {
                    doubleValue = xmlConfig.getDouble(key + ".value", null);
                    if (doubleValue == null || !(doubleValue < 0.0)) break;
                    throw new ConfigurationException("The " + (Object)((Object)toleranceType) + " tolerance type for \"" + key + "\" must be a positive value. Found this value: " + doubleValue);
                }
                default: {
                    throw new ConfigurationException("Unknown Tolerance Type specified in config for <" + type + ">: " + (Object)((Object)toleranceType));
                }
            }
            if (doubleValue != null) {
                return new Tolerance(doubleValue, toleranceType);
            }
        }
        return null;
    }

    private static Map<String, List<String>> parseEquivalentTermsMap(XMLConfiguration xmlConfig) {
        LinkedHashMap<String, List<String>> equivalentTermsMap = new LinkedHashMap<String, List<String>>();
        Object prop = xmlConfig.getProperty("termMappings.termMapping.term");
        if (prop != null) {
            if (prop instanceof Collection) {
                int size = ((Collection)prop).size();
                for (int i = 0; i < size; ++i) {
                    String termElement = "termMappings.termMapping(" + i + ")";
                    DuplicateDataConfig.parseTermMapping(termElement, xmlConfig, equivalentTermsMap);
                }
            } else {
                String termElement = "termMappings.termMapping";
                DuplicateDataConfig.parseTermMapping("termMappings.termMapping", xmlConfig, equivalentTermsMap);
            }
        }
        return equivalentTermsMap;
    }

    private static void parseTermMapping(String termElement, XMLConfiguration xmlConfig, Map<String, List<String>> equivalentTermsMap) {
        String term = xmlConfig.getString(termElement + ".term");
        String equivalentProp = xmlConfig.getString(termElement + ".equivalents.equivalent");
        if (equivalentProp instanceof Collection) {
            int equivalentSize = ((Collection)((Object)equivalentProp)).size();
            if (term != null && equivalentSize > 1) {
                ArrayList<String> equivalents = new ArrayList<String>();
                for (int j = 0; j < equivalentSize; ++j) {
                    String equivalent = xmlConfig.getString(termElement + ".equivalents.equivalent(" + j + ")");
                    if (equivalent == null) continue;
                    equivalents.add(equivalent);
                }
                equivalentTermsMap.put(term, equivalents);
            }
        } else {
            ArrayList<String> equivalents = new ArrayList<String>();
            String equivalent = xmlConfig.getString(termElement + ".equivalents.equivalent");
            if (equivalent != null) {
                equivalents.add(equivalent);
                if (term != null) {
                    equivalentTermsMap.put(term, equivalents);
                }
            }
        }
    }

    public Tolerance getBooleanTolerance() {
        return this.booleanTolerance;
    }

    public Tolerance getByteTolerance() {
        return this.byteTolerance;
    }

    public Tolerance getDateTolerance() {
        return this.dateTolerance;
    }

    public Tolerance getDoubleTolerance() {
        return this.doubleTolerance;
    }

    public Tolerance getFloatTolerance() {
        return this.floatTolerance;
    }

    public Tolerance getIntegerTolerance() {
        return this.integerTolerance;
    }

    public Tolerance getLongTolerance() {
        return this.longTolerance;
    }

    public Tolerance getShortTolerance() {
        return this.shortTolerance;
    }

    public Tolerance getStringTolerance() {
        return this.stringTolerance;
    }

    public Tolerance getUriTolerance() {
        return this.uriTolerance;
    }

    public Map<String, List<String>> getEquivalentTermsMap() {
        return this.equivalentTermsMap;
    }

    public boolean isDetectionEnabled() {
        return this.isDetectionEnabled;
    }
}

