/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.smarturi.duplication;

import java.text.NumberFormat;
import java.util.Objects;
import org.apache.rya.indexing.smarturi.duplication.ToleranceType;

public class Tolerance {
    private final Double value;
    private final ToleranceType toleranceType;

    public Tolerance(Double value, ToleranceType toleranceType) {
        this.value = Objects.requireNonNull(value);
        this.toleranceType = Objects.requireNonNull(toleranceType);
    }

    public Double getValue() {
        return this.value;
    }

    public ToleranceType getToleranceType() {
        return this.toleranceType;
    }

    public String toString() {
        switch (this.toleranceType) {
            case PERCENTAGE: {
                return NumberFormat.getPercentInstance().format(this.value);
            }
            case DIFFERENCE: {
                return this.value.toString();
            }
        }
        return "Unknown Tolerance Type with value: " + this.value.toString();
    }
}

