/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.smarturi.duplication;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.resolver.impl.DateTimeRyaTypeResolver;
import org.apache.rya.indexing.entity.model.Entity;
import org.apache.rya.indexing.entity.model.Property;
import org.apache.rya.indexing.smarturi.SmartUriAdapter;
import org.apache.rya.indexing.smarturi.SmartUriException;
import org.apache.rya.indexing.smarturi.duplication.ApproxEqualsDetector;
import org.apache.rya.indexing.smarturi.duplication.Tolerance;
import org.apache.rya.indexing.smarturi.duplication.ToleranceType;
import org.apache.rya.indexing.smarturi.duplication.conf.DuplicateDataConfig;
import org.calrissian.mango.types.exception.TypeEncodingException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

public class DuplicateDataDetector {
    private final Map<IRI, ApproxEqualsDetector<?>> uriMap = new HashMap();
    private final Map<Class<?>, ApproxEqualsDetector<?>> classMap = new HashMap();
    private boolean isDetectionEnabled;

    public DuplicateDataDetector(DuplicateDataConfig duplicateDataConfig) {
        this(duplicateDataConfig.getBooleanTolerance(), duplicateDataConfig.getByteTolerance(), duplicateDataConfig.getDateTolerance(), duplicateDataConfig.getDoubleTolerance(), duplicateDataConfig.getFloatTolerance(), duplicateDataConfig.getIntegerTolerance(), duplicateDataConfig.getLongTolerance(), duplicateDataConfig.getShortTolerance(), duplicateDataConfig.getStringTolerance(), duplicateDataConfig.getUriTolerance(), duplicateDataConfig.getEquivalentTermsMap(), duplicateDataConfig.isDetectionEnabled());
    }

    public DuplicateDataDetector() throws ConfigurationException {
        this(new DuplicateDataConfig());
    }

    public DuplicateDataDetector(double tolerance) {
        this(new Tolerance(tolerance, ToleranceType.DIFFERENCE), new LinkedHashMap<String, List<String>>());
    }

    public DuplicateDataDetector(Tolerance tolerance, Map<String, List<String>> equivalentTermsMap) {
        this(tolerance, tolerance, tolerance, tolerance, tolerance, tolerance, tolerance, tolerance, tolerance, tolerance, equivalentTermsMap, true);
    }

    public DuplicateDataDetector(Tolerance booleanTolerance, Tolerance byteTolerance, Tolerance dateTolerance, Tolerance doubleTolerance, Tolerance floatTolerance, Tolerance integerTolerance, Tolerance longTolerance, Tolerance shortTolerance, Tolerance stringTolerance, Tolerance uriTolerance, Map<String, List<String>> equivalentTermsMap, boolean isDetectionEnabled) {
        this.init(booleanTolerance, byteTolerance, dateTolerance, doubleTolerance, floatTolerance, integerTolerance, longTolerance, shortTolerance, stringTolerance, uriTolerance, equivalentTermsMap, isDetectionEnabled);
    }

    private void init(Tolerance booleanTolerance, Tolerance byteTolerance, Tolerance dateTolerance, Tolerance doubleTolerance, Tolerance floatTolerance, Tolerance integerTolerance, Tolerance longTolerance, Tolerance shortTolerance, Tolerance stringTolerance, Tolerance uriTolerance, Map<String, List<String>> equivalentTermsMap, boolean isDetectionEnabled) {
        ArrayList<ApproxEqualsDetector<Boolean>> detectors = new ArrayList<ApproxEqualsDetector<Boolean>>();
        detectors.add(new BooleanApproxEqualsDetector(booleanTolerance));
        detectors.add(new ByteApproxEqualsDetector(byteTolerance));
        detectors.add(new DateApproxEqualsDetector(dateTolerance));
        detectors.add(new DateTimeApproxEqualsDetector(dateTolerance));
        detectors.add(new DoubleApproxEqualsDetector(doubleTolerance));
        detectors.add(new FloatApproxEqualsDetector(floatTolerance));
        detectors.add(new IntegerApproxEqualsDetector(integerTolerance));
        detectors.add(new LongApproxEqualsDetector(longTolerance));
        detectors.add(new ShortApproxEqualsDetector(shortTolerance));
        detectors.add(new StringApproxEqualsDetector(stringTolerance, equivalentTermsMap));
        detectors.add(new UriApproxEqualsDetector(uriTolerance));
        for (ApproxEqualsDetector approxEqualsDetector : detectors) {
            this.uriMap.put(approxEqualsDetector.getXmlSchemaUri(), approxEqualsDetector);
            this.classMap.put(approxEqualsDetector.getTypeClass(), approxEqualsDetector);
        }
        this.isDetectionEnabled = isDetectionEnabled;
    }

    public boolean isDetectionEnabled() {
        return this.isDetectionEnabled;
    }

    public void removeDuplicatesFromCollection(List<Entity> entities) throws SmartUriException {
        Objects.requireNonNull(entities);
        TreeSet<Integer> indicesToRemove = new TreeSet<Integer>((a, b) -> Integer.compare(b, a));
        if (entities != null && entities.size() > 1) {
            for (int i = 0; i < entities.size() - 1; ++i) {
                Entity entity1 = entities.get(i);
                for (int j = entities.size() - 1; j > i; --j) {
                    Entity entity2 = entities.get(j);
                    boolean areDuplicates = this.compareEntities(entity1, entity2);
                    if (!areDuplicates) continue;
                    indicesToRemove.add(j);
                }
            }
        }
        if (!indicesToRemove.isEmpty()) {
            Iterator iterator = indicesToRemove.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                entities.remove(index);
            }
        }
    }

    public boolean compareSmartUris(IRI uri1, IRI uri2) throws SmartUriException {
        Objects.requireNonNull(uri1);
        Objects.requireNonNull(uri2);
        Entity entity1 = SmartUriAdapter.deserializeUriEntity(uri1);
        Entity entity2 = SmartUriAdapter.deserializeUriEntity(uri2);
        return this.compareEntities(entity1, entity2);
    }

    public boolean compareEntities(Entity entity1, Entity entity2) throws SmartUriException {
        Objects.requireNonNull(entity1);
        Objects.requireNonNull(entity2);
        boolean allValuesNearlyEqual = true;
        ImmutableList<RyaIRI> types1 = entity1.getExplicitTypeIds();
        ImmutableList<RyaIRI> types2 = entity2.getExplicitTypeIds();
        boolean doBothHaveSameTypes = types1.containsAll((Collection<?>)types2);
        if (!doBothHaveSameTypes) {
            return false;
        }
        for (Map.Entry entry : entity1.getProperties().entrySet()) {
            RyaIRI typeIdUri = (RyaIRI)entry.getKey();
            for (Map.Entry typeProperty : ((ImmutableMap)entry.getValue()).entrySet()) {
                RyaIRI propertyNameUri = (RyaIRI)typeProperty.getKey();
                Property property1 = (Property)typeProperty.getValue();
                Optional<Property> p2 = entity2.lookupTypeProperty(typeIdUri, propertyNameUri);
                if (p2.isPresent()) {
                    Property property2 = p2.get();
                    RyaType value1 = property1.getValue();
                    RyaType value2 = property2.getValue();
                    String data1 = value1.getData();
                    String data2 = value2.getData();
                    IRI xmlSchemaUri1 = value1.getDataType();
                    ApproxEqualsDetector<?> approxEqualsDetector = this.uriMap.get(xmlSchemaUri1);
                    if (approxEqualsDetector == null) {
                        throw new SmartUriException("No appropriate detector found for the type: " + xmlSchemaUri1);
                    }
                    boolean approxEquals = approxEqualsDetector.areApproxEquals(data1, data2);
                    if (approxEquals) continue;
                    allValuesNearlyEqual = false;
                    break;
                }
                allValuesNearlyEqual = false;
                break;
            }
            if (allValuesNearlyEqual) continue;
            break;
        }
        return allValuesNearlyEqual;
    }

    public ApproxEqualsDetector<?> getDetectorForType(Class<?> clazz) {
        return this.classMap.get(clazz);
    }

    private static boolean isOnlyOneNull(Object lhs, Object rhs) {
        return lhs == null && rhs != null || lhs != null && rhs == null;
    }

    public static class UriApproxEqualsDetector
    implements ApproxEqualsDetector<IRI> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(1.0, ToleranceType.DIFFERENCE);
        private final Tolerance tolerance;

        public UriApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(IRI lhs, IRI rhs) {
            String uriString2;
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (Objects.equals(lhs, rhs)) {
                return true;
            }
            String uriString1 = lhs.stringValue();
            if (StringUtils.equalsIgnoreCase((String)uriString1, (String)(uriString2 = rhs.stringValue()))) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            int distance = StringUtils.getLevenshteinDistance((String)uriString1, (String)uriString2);
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (uriString1.length() == 0) {
                        return uriString1.length() == uriString2.length();
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    return (double)distance / (double)uriString1.length() <= this.tolerance.getValue();
                }
            }
            return (double)distance <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public IRI convertStringToObject(String string) throws SmartUriException {
            return SimpleValueFactory.getInstance().createIRI(string);
        }

        @Override
        public Class<?> getTypeClass() {
            return IRI.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.ANYURI;
        }
    }

    public static class StringApproxEqualsDetector
    implements ApproxEqualsDetector<String> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(0.05, ToleranceType.PERCENTAGE);
        private final Tolerance tolerance;
        private final Map<String, List<String>> equivalentTermsMap;

        public StringApproxEqualsDetector(Tolerance tolerance, Map<String, List<String>> equivalentTermsMap) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
            this.equivalentTermsMap = equivalentTermsMap;
        }

        @Override
        public boolean areObjectsApproxEquals(String lhs, String rhs) {
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (StringUtils.equalsIgnoreCase((String)lhs, (String)rhs)) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            List<String> lhsTermEquivalents = this.equivalentTermsMap.get(lhs);
            if (lhsTermEquivalents != null && lhsTermEquivalents.contains(rhs)) {
                return true;
            }
            int distance = StringUtils.getLevenshteinDistance((String)lhs, (String)rhs);
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (lhs.length() == 0) {
                        return lhs.length() == rhs.length();
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    return (double)distance / (double)lhs.length() <= this.tolerance.getValue();
                }
            }
            return (double)distance <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public String convertStringToObject(String string) throws SmartUriException {
            return string;
        }

        @Override
        public Class<?> getTypeClass() {
            return String.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.STRING;
        }
    }

    public static class ShortApproxEqualsDetector
    implements ApproxEqualsDetector<Short> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(1.0, ToleranceType.DIFFERENCE);
        private final Tolerance tolerance;

        public ShortApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(Short lhs, Short rhs) {
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (Objects.equals(lhs, rhs)) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (lhs == 0) {
                        return lhs == rhs;
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    return (double)Math.abs(lhs - rhs) / (double)lhs.shortValue() <= this.tolerance.getValue();
                }
            }
            return (double)Math.abs(lhs - rhs) <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public Short convertStringToObject(String string) throws SmartUriException {
            return Short.valueOf(string);
        }

        @Override
        public Class<?> getTypeClass() {
            return Short.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.SHORT;
        }
    }

    public static class LongApproxEqualsDetector
    implements ApproxEqualsDetector<Long> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(1.0, ToleranceType.DIFFERENCE);
        private final Tolerance tolerance;

        public LongApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(Long lhs, Long rhs) {
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (Objects.equals(lhs, rhs)) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (lhs == 0L) {
                        return lhs == rhs;
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    return (double)Math.abs(lhs - rhs) / (double)lhs.longValue() <= this.tolerance.getValue();
                }
            }
            return (double)Math.abs(lhs - rhs) <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public Long convertStringToObject(String string) throws SmartUriException {
            return Long.valueOf(string);
        }

        @Override
        public Class<?> getTypeClass() {
            return Long.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.LONG;
        }
    }

    public static class IntegerApproxEqualsDetector
    implements ApproxEqualsDetector<Integer> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(1.0, ToleranceType.DIFFERENCE);
        private final Tolerance tolerance;

        public IntegerApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(Integer lhs, Integer rhs) {
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (Objects.equals(lhs, rhs)) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (lhs == 0) {
                        return lhs == rhs;
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    return (double)Math.abs(lhs - rhs) / (double)lhs.intValue() <= this.tolerance.getValue();
                }
            }
            return (double)Math.abs(lhs - rhs) <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public Integer convertStringToObject(String string) throws SmartUriException {
            return Integer.valueOf(string);
        }

        @Override
        public Class<?> getTypeClass() {
            return Integer.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.INTEGER;
        }
    }

    public static class FloatApproxEqualsDetector
    implements ApproxEqualsDetector<Float> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(1.0E-4, ToleranceType.PERCENTAGE);
        private final Tolerance tolerance;

        public FloatApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(Float lhs, Float rhs) {
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (Objects.equals(lhs, rhs)) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            BigDecimal lhsBd = new BigDecimal(String.valueOf(lhs));
            BigDecimal rhsBd = new BigDecimal(String.valueOf(rhs));
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (lhs.floatValue() == 0.0f) {
                        return lhs == rhs;
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    BigDecimal absDiff = lhsBd.subtract(rhsBd).abs();
                    try {
                        BigDecimal percent = absDiff.divide(lhsBd);
                        return (double)percent.floatValue() <= this.tolerance.getValue();
                    }
                    catch (ArithmeticException e) {
                        return (double)Math.abs(lhs.floatValue() - rhs.floatValue()) / (double)lhs.floatValue() <= this.tolerance.getValue();
                    }
                }
            }
            BigDecimal absDiff1 = lhsBd.subtract(rhsBd).abs();
            return (double)absDiff1.floatValue() <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public Float convertStringToObject(String string) throws SmartUriException {
            return Float.valueOf(string);
        }

        @Override
        public Class<?> getTypeClass() {
            return Float.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.FLOAT;
        }
    }

    public static class DoubleApproxEqualsDetector
    implements ApproxEqualsDetector<Double> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(1.0E-4, ToleranceType.PERCENTAGE);
        private final Tolerance tolerance;

        public DoubleApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(Double lhs, Double rhs) {
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (Objects.equals(lhs, rhs)) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            BigDecimal lhsBd = new BigDecimal(String.valueOf(lhs));
            BigDecimal rhsBd = new BigDecimal(String.valueOf(rhs));
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (lhs == 0.0) {
                        return lhs == rhs;
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    BigDecimal absDiff = lhsBd.subtract(rhsBd).abs();
                    try {
                        BigDecimal percent = absDiff.divide(lhsBd);
                        return percent.doubleValue() <= this.tolerance.getValue();
                    }
                    catch (ArithmeticException e) {
                        return Math.abs(lhs - rhs) / lhs <= this.tolerance.getValue();
                    }
                }
            }
            BigDecimal absDiff1 = lhsBd.subtract(rhsBd).abs();
            return absDiff1.doubleValue() <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public Double convertStringToObject(String string) throws SmartUriException {
            return Double.valueOf(string);
        }

        @Override
        public Class<?> getTypeClass() {
            return Double.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.DOUBLE;
        }
    }

    public static class DateTimeApproxEqualsDetector
    implements ApproxEqualsDetector<DateTime> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(500.0, ToleranceType.DIFFERENCE);
        private final Tolerance tolerance;

        public DateTimeApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(DateTime lhs, DateTime rhs) {
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (Objects.equals(lhs, rhs)) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            long lhsTime = lhs.getMillis();
            long rhsTime = rhs.getMillis();
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (lhsTime == 0L) {
                        return lhsTime == rhsTime;
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    return (double)Math.abs(lhsTime - rhsTime) / (double)lhsTime <= this.tolerance.getValue();
                }
            }
            return (double)Math.abs(lhsTime - rhsTime) <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public DateTime convertStringToObject(String string) throws SmartUriException {
            DateTime dateTime = null;
            try {
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)DateTimeRyaTypeResolver.XMLDATETIME_PARSER);
            }
            catch (TypeEncodingException e) {
                throw new SmartUriException("Exception occurred serializing data[" + string + "]", e);
            }
            return dateTime;
        }

        @Override
        public Class<?> getTypeClass() {
            return DateTime.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.DATETIME;
        }
    }

    public static class DateApproxEqualsDetector
    implements ApproxEqualsDetector<Date> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(500.0, ToleranceType.DIFFERENCE);
        private final Tolerance tolerance;

        public DateApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(Date lhs, Date rhs) {
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (Objects.equals(lhs, rhs)) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            long lhsTime = lhs.getTime();
            long rhsTime = rhs.getTime();
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (lhsTime == 0L) {
                        return lhsTime == rhsTime;
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    return (double)Math.abs(lhsTime - rhsTime) / (double)lhsTime <= this.tolerance.getValue();
                }
            }
            return (double)Math.abs(lhsTime - rhsTime) <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public Date convertStringToObject(String string) throws SmartUriException {
            DateTime dateTime = null;
            try {
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)DateTimeRyaTypeResolver.XMLDATETIME_PARSER);
            }
            catch (TypeEncodingException e) {
                throw new SmartUriException("Exception occurred serializing data[" + string + "]", e);
            }
            Date date = dateTime.toDate();
            return date;
        }

        @Override
        public Class<?> getTypeClass() {
            return Date.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.DATE;
        }
    }

    public static class ByteApproxEqualsDetector
    implements ApproxEqualsDetector<Byte> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(0.0, ToleranceType.DIFFERENCE);
        private final Tolerance tolerance;

        public ByteApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(Byte lhs, Byte rhs) {
            if (DuplicateDataDetector.isOnlyOneNull(lhs, rhs)) {
                return false;
            }
            if (Objects.equals(lhs, rhs)) {
                return true;
            }
            if (this.tolerance.getValue() == 0.0) {
                return false;
            }
            switch (this.tolerance.getToleranceType()) {
                case PERCENTAGE: {
                    if (lhs == 0) {
                        return lhs == rhs;
                    }
                    if (this.tolerance.getValue() >= 1.0) {
                        return true;
                    }
                    return (double)Math.abs(lhs - rhs) / (double)lhs.byteValue() <= this.tolerance.getValue();
                }
            }
            return (double)Math.abs(lhs - rhs) <= this.tolerance.getValue();
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public Byte convertStringToObject(String string) throws SmartUriException {
            return Byte.valueOf(string);
        }

        @Override
        public Class<?> getTypeClass() {
            return Byte.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.BYTE;
        }
    }

    public static class BooleanApproxEqualsDetector
    implements ApproxEqualsDetector<Boolean> {
        private static final Tolerance DEFAULT_TOLERANCE = new Tolerance(0.0, ToleranceType.DIFFERENCE);
        private final Tolerance tolerance;

        public BooleanApproxEqualsDetector(Tolerance tolerance) {
            this.tolerance = tolerance != null ? tolerance : this.getDefaultTolerance();
        }

        @Override
        public boolean areObjectsApproxEquals(Boolean lhs, Boolean rhs) {
            return this.tolerance.getValue() != 0.0 || Objects.equals(lhs, rhs);
        }

        @Override
        public Tolerance getDefaultTolerance() {
            return DEFAULT_TOLERANCE;
        }

        @Override
        public Boolean convertStringToObject(String string) throws SmartUriException {
            return Boolean.valueOf(string);
        }

        @Override
        public Class<?> getTypeClass() {
            return Boolean.class;
        }

        @Override
        public IRI getXmlSchemaUri() {
            return XMLSchema.BOOLEAN;
        }
    }
}

