/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.smarturi;

import com.google.common.base.Charsets;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.resolver.RdfToRyaConversions;
import org.apache.rya.api.resolver.RyaToRdfConversions;
import org.apache.rya.indexing.entity.model.Entity;
import org.apache.rya.indexing.entity.model.Property;
import org.apache.rya.indexing.smarturi.SmartUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class SmartUriAdapter {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private static final String ENTITY_TYPE_MAP_URN = "urn://entityTypeMap";
    private static final IRI RYA_TYPES_URI = VF.createIRI("urn://ryaTypes");

    private SmartUriAdapter() {
    }

    private static IRI createTypePropertiesUri(ImmutableMap<RyaIRI, ImmutableMap<RyaIRI, Property>> typeProperties) throws SmartUriException {
        String uriString;
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry typeProperty : typeProperties.entrySet()) {
            RyaIRI type = (RyaIRI)typeProperty.getKey();
            Map propertyMap = (Map)typeProperty.getValue();
            IRI typeUri = SmartUriAdapter.createIndividualTypeWithPropertiesUri(type, propertyMap);
            String keyString = type.getDataType().getLocalName();
            String valueString = typeUri.getLocalName();
            nameValuePairs.add(new BasicNameValuePair(keyString, valueString));
        }
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.addParameters(nameValuePairs);
        try {
            URI uri = uriBuilder.build();
            String queryString = uri.getRawSchemeSpecificPart();
            uriString = "urn:test" + queryString;
        }
        catch (URISyntaxException e) {
            throw new SmartUriException("Unable to create type properties for the Smart URI", e);
        }
        return VF.createIRI(uriString);
    }

    private static String getShortNameForType(RyaIRI type) throws SmartUriException {
        String shortName = VF.createIRI(type.getData()).getLocalName();
        return shortName;
    }

    private static String addTypePrefixToUri(String uriString, String typePrefix) {
        String localName = VF.createIRI(uriString).getLocalName();
        String beginning = StringUtils.removeEnd((String)uriString, (String)localName);
        String formattedUriString = beginning + typePrefix + localName;
        return formattedUriString;
    }

    private static String removeTypePrefixFromUri(String uriString, String typePrefix) {
        String localName = VF.createIRI(uriString).getLocalName();
        String beginning = StringUtils.removeEnd((String)uriString, (String)localName);
        String replacement = localName.replaceFirst(typePrefix + ".", "");
        String formattedUriString = beginning + replacement;
        return formattedUriString;
    }

    private static Map<RyaIRI, String> createTypeMap(List<RyaIRI> types) throws SmartUriException {
        LinkedHashMap<RyaIRI, String> map = new LinkedHashMap<RyaIRI, String>();
        for (RyaIRI type : types) {
            String shortName = SmartUriAdapter.getShortNameForType(type);
            map.put(type, shortName);
        }
        return map;
    }

    private static IRI createTypeMapUri(List<RyaIRI> types) throws SmartUriException {
        String uriString;
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (RyaIRI type : types) {
            String shortName = SmartUriAdapter.getShortNameForType(type);
            nameValuePairs.add(new BasicNameValuePair(type.getData(), shortName));
        }
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.addParameters(nameValuePairs);
        try {
            URI uri = uriBuilder.build();
            String queryString = uri.getRawSchemeSpecificPart();
            uriString = ENTITY_TYPE_MAP_URN + queryString;
        }
        catch (URISyntaxException e) {
            throw new SmartUriException("Unable to create type properties for the Smart URI", e);
        }
        return VF.createIRI(uriString);
    }

    private static Map<RyaIRI, String> convertIriToTypeMap(IRI typeMapIri) throws SmartUriException {
        URI uri;
        HashMap<RyaIRI, String> map = new HashMap<RyaIRI, String>();
        try {
            URIBuilder uriBuilder = new URIBuilder(typeMapIri.stringValue());
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new SmartUriException("Unable to parse Rya type map in Smart URI", e);
        }
        List params = URLEncodedUtils.parse((URI)uri, (String)Charsets.UTF_8.name());
        for (NameValuePair param : params) {
            String name = param.getName();
            String value = param.getValue();
            RyaIRI type = new RyaIRI(name);
            map.put(type, value);
        }
        return map;
    }

    private static IRI createIndividualTypeWithPropertiesUri(RyaIRI type, Map<RyaIRI, Property> map) throws SmartUriException {
        String uriString;
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<RyaIRI, Property> entry : map.entrySet()) {
            RyaIRI key = entry.getKey();
            Property property = entry.getValue();
            RyaType ryaType = property.getValue();
            String keyString = VF.createIRI(key.getData()).getLocalName();
            Value value = RyaToRdfConversions.convertValue((RyaType)ryaType);
            String valueString = value.stringValue();
            nameValuePairs.add(new BasicNameValuePair(keyString, valueString));
        }
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.addParameters(nameValuePairs);
        try {
            URI uri = uriBuilder.build();
            String queryString = uri.getRawSchemeSpecificPart();
            uriString = type.getData() + queryString;
        }
        catch (URISyntaxException e) {
            throw new SmartUriException("Unable to create type URI with all its properties for the Smart URI", e);
        }
        return VF.createIRI(uriString);
    }

    private static Entity convertMapToEntity(RyaIRI subject, Map<RyaIRI, Map<IRI, Value>> map) {
        Entity.Builder entityBuilder = Entity.builder();
        entityBuilder.setSubject(subject);
        for (Map.Entry<RyaIRI, Map<IRI, Value>> typeEntry : map.entrySet()) {
            RyaIRI type = typeEntry.getKey();
            Map<IRI, Value> subMap = typeEntry.getValue();
            entityBuilder.setExplicitType(type);
            for (Map.Entry<IRI, Value> entry : subMap.entrySet()) {
                IRI uri = entry.getKey();
                Value value = entry.getValue();
                RyaIRI ryaIri = new RyaIRI(uri.stringValue());
                RyaIRI ryaName = new RyaIRI(uri.stringValue());
                RyaType ryaType = new RyaType(value.stringValue());
                Property property = new Property(ryaName, ryaType);
                entityBuilder.setProperty(ryaIri, property);
            }
        }
        Entity entity = entityBuilder.build();
        return entity;
    }

    public static RyaIRI findSubject(IRI uri) throws SmartUriException {
        String uriString = uri.stringValue();
        return SmartUriAdapter.findSubject(uriString);
    }

    public static RyaIRI findSubject(String uriString) throws SmartUriException {
        RyaIRI subject;
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new SmartUriException("Could not find subject in Smart URI", e);
        }
        String fullFragment = uri.getFragment();
        if (fullFragment != null) {
            int queryPosition = fullFragment.indexOf("?");
            String partialFragment = null;
            if (queryPosition != -1) {
                partialFragment = fullFragment.substring(0, queryPosition);
            }
            String subjectString = uri.getScheme() + ":" + uri.getSchemeSpecificPart() + "#" + partialFragment;
            subject = new RyaIRI(subjectString);
        } else {
            int queryPosition = uriString.indexOf("?");
            String subjectString = null;
            subjectString = queryPosition != -1 ? uriString.substring(0, queryPosition) : uriString;
            subject = new RyaIRI(subjectString);
        }
        return subject;
    }

    public static IRI serializeUriEntity(Entity entity) throws SmartUriException {
        LinkedHashMap<IRI, Value> objectMap = new LinkedHashMap<IRI, Value>();
        ImmutableList<RyaIRI> typeIds = entity.getExplicitTypeIds();
        Map<RyaIRI, String> ryaTypeMap = SmartUriAdapter.createTypeMap(typeIds);
        IRI ryaTypeMapUri = SmartUriAdapter.createTypeMapUri(typeIds);
        RyaType valueRyaType = new RyaType(XMLSchema.ANYURI, ryaTypeMapUri.stringValue());
        Value typeValue = RyaToRdfConversions.convertValue((RyaType)valueRyaType);
        objectMap.put(RYA_TYPES_URI, typeValue);
        RyaIRI subject = entity.getSubject();
        ImmutableMap<RyaIRI, ImmutableMap<RyaIRI, Property>> typeMap = entity.getProperties();
        for (Map.Entry typeEntry : typeMap.entrySet()) {
            RyaIRI type = (RyaIRI)typeEntry.getKey();
            String typeShortName = ryaTypeMap.get(type);
            typeShortName = typeShortName != null ? typeShortName + "." : "";
            ImmutableMap typeProperties = (ImmutableMap)typeEntry.getValue();
            for (Map.Entry properties : typeProperties.entrySet()) {
                RyaIRI key = (RyaIRI)properties.getKey();
                Property property = (Property)properties.getValue();
                String valueString = property.getValue().getData();
                RyaType ryaType = property.getValue();
                Value value = RyaToRdfConversions.convertValue((RyaType)ryaType);
                String formattedKey = key.getData();
                if (StringUtils.isNotBlank((CharSequence)typeShortName)) {
                    formattedKey = SmartUriAdapter.addTypePrefixToUri(formattedKey, typeShortName);
                }
                IRI iri = VF.createIRI(formattedKey);
                objectMap.put(iri, value);
            }
        }
        return SmartUriAdapter.serializeUri(subject, objectMap);
    }

    public static IRI serializeUri(RyaIRI subject, Map<IRI, Value> map) throws SmartUriException {
        String subjectData = subject.getData();
        int fragmentPosition = subjectData.indexOf("#");
        String prefix = subjectData;
        String fragment = null;
        if (fragmentPosition > -1) {
            prefix = subjectData.substring(0, fragmentPosition);
            fragment = subjectData.substring(fragmentPosition + 1, subjectData.length());
        }
        URIBuilder uriBuilder = null;
        try {
            uriBuilder = fragmentPosition > -1 ? new URIBuilder(new URI("urn://" + fragment)) : new URIBuilder(new URI(subjectData.replaceFirst(":", "://")));
        }
        catch (URISyntaxException e) {
            throw new SmartUriException("Unable to serialize a Smart URI from the provided properties", e);
        }
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<IRI, Value> entry : map.entrySet()) {
            IRI key = entry.getKey();
            Value value = entry.getValue();
            nameValuePairs.add(new BasicNameValuePair(key.getLocalName(), value.stringValue()));
        }
        uriBuilder.setParameters(nameValuePairs);
        IRI iri = null;
        try {
            if (fragmentPosition > -1) {
                URI partialUri = uriBuilder.build();
                String uriString = StringUtils.removeStart((String)partialUri.getRawSchemeSpecificPart(), (String)"//");
                URIBuilder fragmentUriBuilder = new URIBuilder(new URI(prefix));
                fragmentUriBuilder.setFragment(uriString);
                String fragmentUriString = fragmentUriBuilder.build().toString();
                iri = VF.createIRI(fragmentUriString);
            } else {
                String uriString = uriBuilder.build().toString();
                iri = VF.createIRI(uriString);
            }
        }
        catch (URISyntaxException e) {
            throw new SmartUriException("Smart URI could not serialize the property map.", e);
        }
        return iri;
    }

    public static Map<IRI, Value> deserializeUri(IRI iri) throws SmartUriException {
        String uriString = iri.stringValue();
        int fragmentPosition = uriString.indexOf("#");
        String prefix = uriString.substring(0, fragmentPosition + 1);
        if (fragmentPosition == -1) {
            prefix = uriString.split("\\?", 2)[0];
        }
        String fragment = uriString.substring(fragmentPosition + 1, uriString.length());
        URIBuilder uriBuilder = null;
        try {
            URI queryUri = fragmentPosition > -1 ? new URI("urn://" + fragment) : new URI(uriString);
            uriBuilder = new URIBuilder(queryUri);
        }
        catch (URISyntaxException e) {
            throw new SmartUriException("Unable to deserialize Smart URI", e);
        }
        HashMap<IRI, Value> map = new HashMap<IRI, Value>();
        RyaIRI subject = SmartUriAdapter.findSubject(iri.stringValue());
        List parameters = uriBuilder.getQueryParams();
        Map<Object, Object> entityTypeMap = new LinkedHashMap();
        BiMap invertedEntityTypeMap = new LinkedHashMap();
        LinkedHashMap fullMap = new LinkedHashMap();
        for (NameValuePair pair : parameters) {
            String decoded;
            String keyString = pair.getName();
            String valueString = pair.getValue();
            IRI keyUri = VF.createIRI(prefix + keyString);
            try {
                decoded = URLDecoder.decode(valueString, Charsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new SmartUriException("", e);
            }
            IRI type = TypeDeterminer.determineType(decoded);
            if (type == XMLSchema.ANYURI) {
                if (!keyString.equals(RYA_TYPES_URI.getLocalName())) continue;
                entityTypeMap = SmartUriAdapter.convertIriToTypeMap(VF.createIRI(decoded));
                invertedEntityTypeMap = HashBiMap.create(entityTypeMap).inverse();
                continue;
            }
            int keyPrefixLocation = keyString.indexOf(".");
            String keyPrefix = keyString.substring(0, keyPrefixLocation);
            RyaIRI keyCorrespondingType = (RyaIRI)invertedEntityTypeMap.get(keyPrefix);
            String keyName = keyString.substring(keyPrefixLocation + 1, keyString.length());
            RyaType ryaType = new RyaType(type, valueString);
            Value value = RyaToRdfConversions.convertValue((RyaType)ryaType);
            String formattedKeyUriString = SmartUriAdapter.removeTypePrefixFromUri(keyUri.stringValue(), keyPrefix);
            IRI formattedKeyUri = VF.createIRI(formattedKeyUriString);
            map.put(formattedKeyUri, value);
        }
        return map;
    }

    public static Entity deserializeUriEntity(IRI uri) throws SmartUriException {
        String uriString = uri.stringValue();
        int fragmentPosition = uriString.indexOf("#");
        String prefix = uriString.substring(0, fragmentPosition + 1);
        if (fragmentPosition == -1) {
            prefix = uriString.split("\\?", 2)[0];
        }
        String fragment = uriString.substring(fragmentPosition + 1, uriString.length());
        URIBuilder uriBuilder = null;
        try {
            URI queryUri = fragmentPosition > -1 ? new URI("urn://" + fragment) : new URI(uriString);
            uriBuilder = new URIBuilder(queryUri);
        }
        catch (URISyntaxException e) {
            throw new SmartUriException("Unable to deserialize Smart URI", e);
        }
        RyaIRI subject = SmartUriAdapter.findSubject(uri.stringValue());
        List parameters = uriBuilder.getQueryParams();
        Map<Object, Object> entityTypeMap = new LinkedHashMap();
        BiMap invertedEntityTypeMap = new LinkedHashMap();
        LinkedHashMap<RyaIRI, Map<IRI, Value>> fullMap = new LinkedHashMap<RyaIRI, Map<IRI, Value>>();
        for (NameValuePair pair : parameters) {
            String decoded;
            String keyString = pair.getName();
            String valueString = pair.getValue();
            IRI keyUri = VF.createIRI(prefix + keyString);
            try {
                decoded = URLDecoder.decode(valueString, Charsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new SmartUriException("", e);
            }
            IRI type = TypeDeterminer.determineType(decoded);
            if (type == XMLSchema.ANYURI) {
                if (!keyString.equals(RYA_TYPES_URI.getLocalName())) continue;
                entityTypeMap = SmartUriAdapter.convertIriToTypeMap(VF.createIRI(decoded));
                invertedEntityTypeMap = HashBiMap.create(entityTypeMap).inverse();
                continue;
            }
            int keyPrefixLocation = keyString.indexOf(".");
            String keyPrefix = keyString.substring(0, keyPrefixLocation);
            RyaIRI keyCorrespondingType = (RyaIRI)invertedEntityTypeMap.get(keyPrefix);
            String keyName = keyString.substring(keyPrefixLocation + 1, keyString.length());
            RyaType ryaType = new RyaType(type, valueString);
            Value value = RyaToRdfConversions.convertValue((RyaType)ryaType);
            String formattedKeyUriString = SmartUriAdapter.removeTypePrefixFromUri(keyUri.stringValue(), keyPrefix);
            IRI formattedKeyUri = VF.createIRI(formattedKeyUriString);
            Map map = (Map)fullMap.get(keyCorrespondingType);
            if (map == null) {
                HashMap<IRI, Value> subMap = new HashMap<IRI, Value>();
                subMap.put(formattedKeyUri, value);
                fullMap.put(keyCorrespondingType, subMap);
                continue;
            }
            map.put(formattedKeyUri, value);
            fullMap.put(keyCorrespondingType, map);
        }
        Entity entity = SmartUriAdapter.convertMapToEntity(subject, fullMap);
        return entity;
    }

    public static Map<IRI, Value> entityToValueMap(Entity entity) {
        LinkedHashMap<IRI, Value> map = new LinkedHashMap<IRI, Value>();
        for (Map.Entry entry : entity.getProperties().entrySet()) {
            for (Map.Entry property : ((ImmutableMap)entry.getValue()).entrySet()) {
                RyaIRI propertyKey = (RyaIRI)property.getKey();
                IRI iri = VF.createIRI(propertyKey.getData());
                Property propertyValue = (Property)property.getValue();
                Value value = RyaToRdfConversions.convertValue((RyaType)propertyValue.getValue());
                map.put(iri, value);
            }
        }
        return map;
    }

    public static Set<Property> mapToProperties(Map<IRI, Value> map) {
        LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
        for (Map.Entry<IRI, Value> entry : map.entrySet()) {
            IRI iri = entry.getKey();
            Value value = entry.getValue();
            RyaIRI ryaIri = new RyaIRI(iri.stringValue());
            RyaType ryaType = RdfToRyaConversions.convertValue((Value)value);
            Property property = new Property(ryaIri, ryaType);
            properties.add(property);
        }
        return properties;
    }

    public static Map<IRI, Value> propertiesToMap(Set<Property> properties) {
        LinkedHashMap<IRI, Value> map = new LinkedHashMap<IRI, Value>();
        for (Property property : properties) {
            IRI iri = VF.createIRI(property.getName().getData());
            Value value = RyaToRdfConversions.convertValue((RyaType)property.getValue());
            map.put(iri, value);
        }
        return map;
    }

    private static final class TypeDeterminer {
        private TypeDeterminer() {
        }

        private static IRI determineType(String data) {
            if (Ints.tryParse((String)data) != null) {
                return XMLSchema.INTEGER;
            }
            if (Doubles.tryParse((String)data) != null) {
                return XMLSchema.DOUBLE;
            }
            if (Floats.tryParse((String)data) != null) {
                return XMLSchema.FLOAT;
            }
            if (TypeDeterminer.isShort(data)) {
                return XMLSchema.SHORT;
            }
            if (Longs.tryParse((String)data) != null) {
                return XMLSchema.LONG;
            }
            if (Boolean.parseBoolean(data)) {
                return XMLSchema.BOOLEAN;
            }
            if (TypeDeterminer.isByte(data)) {
                return XMLSchema.BYTE;
            }
            if (TypeDeterminer.isDate(data)) {
                return XMLSchema.DATETIME;
            }
            if (TypeDeterminer.isUri(data)) {
                return XMLSchema.ANYURI;
            }
            return XMLSchema.STRING;
        }

        private static boolean isDate(String data) {
            try {
                DateTime.parse((String)data, (DateTimeFormatter)ISODateTimeFormat.dateTimeParser());
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        private static boolean isShort(String data) {
            try {
                Short.parseShort(data);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private static boolean isByte(String data) {
            try {
                Byte.parseByte(data);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private static boolean isUri(String data) {
            try {
                String decoded = URLDecoder.decode(data, Charsets.UTF_8.name());
                VF.createIRI(decoded);
                return true;
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                return false;
            }
        }
    }
}

