/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.matching.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.instance.AccumuloRyaInstanceDetailsRepository;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.external.tupleSet.AccumuloIndexSet;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.pcj.matching.provider.AbstractPcjIndexSetProvider;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjStorage;
import org.apache.rya.indexing.pcj.storage.accumulo.PcjTableNameFactory;
import org.apache.rya.indexing.pcj.storage.accumulo.PcjTables;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.sail.SailException;

public class AccumuloIndexSetProvider
extends AbstractPcjIndexSetProvider {
    private static final Logger log = Logger.getLogger(AccumuloIndexSetProvider.class);

    public AccumuloIndexSetProvider(Configuration conf) {
        super(conf);
    }

    public AccumuloIndexSetProvider(Configuration conf, List<ExternalTupleSet> indices) {
        super(conf, indices);
    }

    @Override
    protected List<ExternalTupleSet> getIndices() throws AbstractPcjIndexSetProvider.PcjIndexSetException {
        Objects.requireNonNull(this.conf);
        try {
            String tablePrefix = Objects.requireNonNull(this.conf.get("query.tblprefix"));
            Connector conn = Objects.requireNonNull(ConfigUtils.getConnector(this.conf));
            List tables = null;
            if (this.conf instanceof RdfCloudTripleStoreConfiguration) {
                tables = ((RdfCloudTripleStoreConfiguration)this.conf).getPcjTables();
            }
            LinkedHashMap indexTables = Maps.newLinkedHashMap();
            AccumuloPcjStorage storage = new AccumuloPcjStorage(conn, tablePrefix);
            Object object = null;
            try {
                boolean tablesProvided;
                PcjTableNameFactory pcjFactory = new PcjTableNameFactory();
                boolean bl = tablesProvided = tables != null && !tables.isEmpty();
                if (tablesProvided) {
                    for (String table : tables) {
                        indexTables.put(table, storage.getPcjMetadata(pcjFactory.getPcjId(table)).getSparql());
                    }
                } else if (AccumuloIndexSetProvider.hasRyaDetails(tablePrefix, conn)) {
                    List ids = storage.listPcjs();
                    for (String id : ids) {
                        indexTables.put(pcjFactory.makeTableName(tablePrefix, id), storage.getPcjMetadata(id).getSparql());
                    }
                } else {
                    PcjTables pcjTables = new PcjTables();
                    for (String table : conn.tableOperations().list()) {
                        if (!table.startsWith(tablePrefix + "INDEX")) continue;
                        indexTables.put(table, pcjTables.getPcjMetadata(conn, table).getSparql());
                    }
                }
            }
            catch (Throwable pcjFactory) {
                object = pcjFactory;
                throw pcjFactory;
            }
            finally {
                if (storage != null) {
                    if (object != null) {
                        try {
                            storage.close();
                        }
                        catch (Throwable pcjFactory) {
                            ((Throwable)object).addSuppressed(pcjFactory);
                        }
                    } else {
                        storage.close();
                    }
                }
            }
            ArrayList index = Lists.newArrayList();
            if (indexTables.isEmpty()) {
                log.info((Object)"No Index found");
            } else {
                for (String table : indexTables.keySet()) {
                    String indexSparqlString = (String)indexTables.get(table);
                    index.add(new AccumuloIndexSet(indexSparqlString, this.conf, table));
                }
            }
            return index;
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException | PrecomputedJoinStorage.PCJStorageException | MalformedQueryException | QueryEvaluationException | SailException e) {
            throw new AbstractPcjIndexSetProvider.PcjIndexSetException(this, "Failed to retrieve the indicies.", e);
        }
    }

    private static boolean hasRyaDetails(String ryaInstanceName, Connector conn) {
        AccumuloRyaInstanceDetailsRepository detailsRepo = new AccumuloRyaInstanceDetailsRepository(conn, ryaInstanceName);
        try {
            detailsRepo.getRyaInstanceDetails();
            return true;
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            return false;
        }
    }
}

