/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.matching.provider;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.indexing.IndexPlanValidator.IndexedExecutionPlanGenerator;
import org.apache.rya.indexing.IndexPlanValidator.ValidIndexCombinationGenerator;
import org.apache.rya.indexing.external.matching.ExternalSetProvider;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.pcj.matching.PCJOptimizerUtilities;
import org.apache.rya.indexing.pcj.matching.PCJToSegmentConverter;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public abstract class AbstractPcjIndexSetProvider
implements ExternalSetProvider<ExternalTupleSet> {
    protected static final Logger log = Logger.getLogger(AbstractPcjIndexSetProvider.class);
    protected static final PCJToSegmentConverter converter = new PCJToSegmentConverter();
    protected List<ExternalTupleSet> indexCache;
    protected final Configuration conf;
    protected boolean init = false;

    public AbstractPcjIndexSetProvider(Configuration conf) {
        this.conf = Objects.requireNonNull(conf);
    }

    public AbstractPcjIndexSetProvider(Configuration conf, List<ExternalTupleSet> indices) {
        Objects.requireNonNull(conf);
        this.conf = conf;
        this.indexCache = indices;
        this.init = true;
    }

    @VisibleForTesting
    public void setIndices(List<ExternalTupleSet> indices) {
        this.indexCache = indices;
        this.init = true;
    }

    @Override
    public Iterator<List<ExternalTupleSet>> getExternalSetCombos(QuerySegment<ExternalTupleSet> segment) {
        ValidIndexCombinationGenerator comboGen = new ValidIndexCombinationGenerator(segment.getOrderedNodes());
        return comboGen.getValidIndexCombos(this.getExternalSets(segment));
    }

    @Override
    public List<ExternalTupleSet> getExternalSets(QuerySegment<ExternalTupleSet> segment) {
        try {
            if (!this.init) {
                this.indexCache = PCJOptimizerUtilities.getValidPCJs(this.getIndices());
                this.init = true;
            }
            TupleExpr query = segment.getQuery().getTupleExpr();
            IndexedExecutionPlanGenerator iep = new IndexedExecutionPlanGenerator(query, this.indexCache);
            List<ExternalTupleSet> pcjs = iep.getNormalizedIndices();
            ArrayList<ExternalTupleSet> tuples = new ArrayList<ExternalTupleSet>();
            for (ExternalTupleSet tuple : pcjs) {
                QuerySegment<ExternalTupleSet> pcj = converter.setToSegment(tuple);
                if (!segment.containsQuerySegment(pcj)) continue;
                tuples.add(tuple);
            }
            return tuples;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int size() throws Exception {
        if (!this.init) {
            this.indexCache = PCJOptimizerUtilities.getValidPCJs(this.getIndices());
            this.init = true;
        }
        return this.indexCache.size();
    }

    protected abstract List<ExternalTupleSet> getIndices() throws PcjIndexSetException;

    public class PcjIndexSetException
    extends Exception {
        public PcjIndexSetException(String message) {
            super(message);
        }

        public PcjIndexSetException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

